/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.constants.SeparatorConstants;
import io.microsphere.invoke.MethodHandleUtils;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.MemberUtils;
import io.microsphere.reflect.ReflectionUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.Utils;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;

public abstract class AccessibleObjectUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(AccessibleObjectUtils.class);
    private static final String canAccessMethodName = "canAccess";
    private static final String trySetAccessibleMethodName = "trySetAccessible";
    private static final MethodHandle canAccessMethodHandle = MethodHandleUtils.findVirtual(AccessibleObject.class, "canAccess", Object.class);
    private static final MethodHandle trySetAccessibleMethodHandle = MethodHandleUtils.findVirtual(AccessibleObject.class, "trySetAccessible", new Class[0]);

    public static boolean trySetAccessible(AccessibleObject accessibleObject) {
        MethodHandle methodHandle = trySetAccessibleMethodHandle;
        if (methodHandle == null) {
            return AccessibleObjectUtils.setAccessible(accessibleObject);
        }
        return AccessibleObjectUtils.trySetAccessible(methodHandle, accessibleObject);
    }

    public static boolean canAccess(Object object, AccessibleObject accessibleObject) {
        Member member = MemberUtils.asMember(accessibleObject);
        if (MemberUtils.isPublic(member)) {
            return true;
        }
        Boolean access = AccessibleObjectUtils.tryCanAccess(object, accessibleObject);
        return access == null ? accessibleObject.isAccessible() : access.booleanValue();
    }

    static boolean setAccessible(AccessibleObject accessibleObject) {
        boolean accessible = accessibleObject.isAccessible();
        if (!accessible) {
            try {
                accessibleObject.setAccessible(true);
                accessible = true;
            }
            catch (RuntimeException e) {
                AccessibleObjectUtils.handleInaccessibleObjectExceptionIfFound(e);
            }
        }
        return accessible;
    }

    private static boolean trySetAccessible(MethodHandle methodHandle, AccessibleObject accessibleObject) {
        boolean accessible = false;
        try {
            accessible = methodHandle.invokeExact(accessibleObject);
        }
        catch (Throwable e) {
            logger.error("It's failed to invokeExact on {} with accessibleObject : {}", methodHandle, accessibleObject, e);
        }
        return accessible;
    }

    private static Boolean tryCanAccess(Object object, AccessibleObject accessibleObject) {
        Boolean access = null;
        if (canAccessMethodHandle != null) {
            try {
                access = canAccessMethodHandle.invokeExact(accessibleObject, object);
            }
            catch (Throwable e) {
                logger.error("It's failed to invokeExact on {} with object : {} , accessible object : {}", canAccessMethodHandle, object, accessibleObject, e);
            }
        }
        return access;
    }

    private static void handleInaccessibleObjectExceptionIfFound(Throwable e) {
        if (ReflectionUtils.isInaccessibleObjectException(e)) {
            String rawErrorMessage = e.getMessage();
            String moduleName = StringUtils.substringBetween(rawErrorMessage, "module ", " ");
            String packageName = StringUtils.substringBetween(rawErrorMessage, "opens ", "\"");
            StringBuilder errorMessageBuilder = new StringBuilder("JEP 396: Strongly Encapsulate JDK Internals by Default since JDK 16 - https://openjdk.org/jeps/396.");
            errorMessageBuilder.append(SeparatorConstants.LINE_SEPARATOR).append("It's require to add JVM Options '--add-opens=").append(moduleName).append('/').append(packageName).append("=ALL-UNNAMED' for running");
            logger.error(errorMessageBuilder.toString(), e);
        }
    }

    private AccessibleObjectUtils() {
    }
}

