/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.lang.Deprecation;
import io.microsphere.reflect.ConstructorUtils;
import io.microsphere.reflect.ExecutableDefinition;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Version;
import java.lang.reflect.Constructor;

public class ConstructorDefinition
extends ExecutableDefinition<Constructor> {
    public ConstructorDefinition(String since, String declaredClassName, String ... parameterClassNames) {
        super(since, declaredClassName, declaredClassName, parameterClassNames);
    }

    public ConstructorDefinition(String since, Deprecation deprecation, String declaredClassName, String ... parameterClassNames) {
        super(since, deprecation, declaredClassName, declaredClassName, parameterClassNames);
    }

    public ConstructorDefinition(Version since, String declaredClassName, String ... parameterClassNames) {
        super(since, declaredClassName, declaredClassName, parameterClassNames);
    }

    public ConstructorDefinition(Version since, Deprecation deprecation, String declaredClassName, String ... parameterClassNames) {
        super(since, deprecation, declaredClassName, declaredClassName, parameterClassNames);
    }

    @Override
    protected Constructor resolveMember() {
        return ConstructorUtils.findConstructor(super.getDeclaredClass(), super.getParameterTypes());
    }

    public Constructor<?> getConstructor() {
        return (Constructor)this.getMember();
    }

    public <T> T newInstance(Object ... args) {
        return (T)ConstructorUtils.newInstance(this.getConstructor(), args);
    }

    @Override
    public String toString() {
        return "ConstructorDefinition{since=" + this.since + ", deprecation=" + this.deprecation + ", declaredClassName='" + super.getDeclaredClassName() + '\'' + ", declaredClass=" + super.getDeclaredClass() + ", parameterClassName=" + ArrayUtils.arrayToString(this.parameterClassNames) + ", parameterTypes=" + ArrayUtils.arrayToString(super.getParameterTypes()) + '}';
    }
}

