/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.lang.function.ThrowableConsumer;
import io.microsphere.lang.function.ThrowableFunction;
import io.microsphere.lang.function.ThrowableSupplier;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.ExceptionUtils;
import io.microsphere.util.Utils;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;

public abstract class ExecutableUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(ExecutableUtils.class);

    public static <E extends Executable> void execute(E object, ThrowableConsumer<E> callback) throws NullPointerException, IllegalStateException, IllegalArgumentException, RuntimeException {
        ExecutableUtils.execute(object, (E a) -> {
            callback.accept(a);
            return null;
        });
    }

    public static <E extends Executable, R> R execute(E executable, ThrowableSupplier<R> supplier) throws NullPointerException, IllegalStateException, IllegalArgumentException, RuntimeException {
        return (R)ExecutableUtils.execute(executable, (E a) -> supplier.execute());
    }

    public static <E extends Executable, R> R execute(E executableMember, ThrowableFunction<E, R> callback) throws NullPointerException, IllegalStateException, IllegalArgumentException, RuntimeException {
        R result = null;
        RuntimeException failure = null;
        try {
            result = callback.apply(executableMember);
        }
        catch (IllegalAccessException e) {
            String errorMessage = FormatUtils.format("The executable member['{}'] can't be accessed", executableMember);
            failure = new IllegalStateException(errorMessage, e);
        }
        catch (IllegalArgumentException e) {
            String errorMessage = FormatUtils.format("The arguments can't match the executable member['{}'] : {}", executableMember, e.getMessage());
            failure = new IllegalArgumentException(errorMessage, e);
        }
        catch (InvocationTargetException e) {
            String errorMessage = FormatUtils.format("It's failed to invoke the executable member['{}']", executableMember);
            failure = new RuntimeException(errorMessage, e.getTargetException());
        }
        catch (Throwable e) {
            failure = ExceptionUtils.wrap(e, RuntimeException.class);
        }
        if (failure != null) {
            logger.error(failure.getMessage(), failure.getCause());
            throw failure;
        }
        return result;
    }

    private ExecutableUtils() {
    }
}

