/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.lang.function.Predicates;
import io.microsphere.lang.function.Streams;
import io.microsphere.lang.function.ThrowableSupplier;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.AccessibleObjectUtils;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public abstract class FieldUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(FieldUtils.class);

    @Nullable
    public static Field findField(Object object, String fieldName) {
        return FieldUtils.findField(object.getClass(), fieldName);
    }

    @Nullable
    public static Field findField(Class<?> klass, String fieldName) {
        if (klass == null || TypeUtils.isObjectClass(klass)) {
            return null;
        }
        Field field = null;
        try {
            field = klass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            field = FieldUtils.findField(klass.getSuperclass(), fieldName);
        }
        if (field == null && logger.isTraceEnabled()) {
            logger.trace("The field[name :'{}'] not found in class : '{}'", fieldName, klass);
        }
        return field;
    }

    @Nullable
    public static Field findField(Class<?> klass, String fieldName, Class<?> fieldType) {
        return FieldUtils.findField(klass, fieldName, field -> Objects.equals(fieldType, field.getType()));
    }

    @Nullable
    public static Field findField(Class<?> klass, String fieldName, Predicate<? super Field> ... predicates) {
        Field field = FieldUtils.findField(klass, fieldName);
        return Predicates.and(predicates).test(field) ? field : null;
    }

    @Nullable
    public static <T> T getStaticFieldValue(Class<?> klass, String fieldName) {
        Field field = FieldUtils.findField(klass, fieldName);
        return FieldUtils.getStaticFieldValue(field);
    }

    @Nullable
    public static <T> T getStaticFieldValue(Field field) {
        return (T)FieldUtils.getFieldValue(null, field);
    }

    @Nullable
    public static <V> V setStaticFieldValue(Class<?> klass, String fieldName, V fieldValue) {
        Field field = FieldUtils.findField(klass, fieldName);
        return FieldUtils.setFieldValue(null, field, fieldValue);
    }

    @Nonnull
    public static Set<Field> findAllFields(Class<?> declaredClass, Predicate<? super Field> ... fieldFilters) {
        LinkedHashSet allFields = new LinkedHashSet();
        CollectionUtils.addAll(allFields, declaredClass.getFields());
        for (Class<?> superType : ClassUtils.getAllInheritedTypes(declaredClass)) {
            CollectionUtils.addAll(allFields, superType.getFields());
        }
        return Streams.filter(allFields, Predicates.and(fieldFilters));
    }

    @Nonnull
    public static Set<Field> findAllDeclaredFields(Class<?> declaredClass, Predicate<? super Field> ... fieldFilters) {
        LinkedHashSet allDeclaredFields = new LinkedHashSet();
        CollectionUtils.addAll(allDeclaredFields, declaredClass.getDeclaredFields());
        for (Class<?> superType : ClassUtils.getAllInheritedTypes(declaredClass)) {
            CollectionUtils.addAll(allDeclaredFields, superType.getDeclaredFields());
        }
        return Streams.filter(allDeclaredFields, Predicates.and(fieldFilters));
    }

    @Nullable
    public static Field getDeclaredField(Class<?> declaredClass, String fieldName) {
        return ThrowableSupplier.execute(() -> declaredClass.getDeclaredField(fieldName));
    }

    @Nullable
    public static <V> V getFieldValue(Object instance, String fieldName) throws IllegalStateException, IllegalArgumentException {
        return FieldUtils.getFieldValue(instance, FieldUtils.findField(instance, fieldName));
    }

    @Nullable
    public static <V> V getFieldValue(Object instance, String fieldName, V defaultValue) throws IllegalStateException, IllegalArgumentException {
        V value = FieldUtils.getFieldValue(instance, fieldName);
        return value != null ? value : defaultValue;
    }

    @Nullable
    public static <V> V getFieldValue(Object instance, String fieldName, Class<V> fieldType) throws IllegalStateException, IllegalArgumentException {
        Field field = FieldUtils.findField(instance.getClass(), fieldName, fieldType);
        return FieldUtils.getFieldValue(instance, field);
    }

    @Nullable
    public static <V> V getFieldValue(Object instance, Field field) throws IllegalStateException, IllegalArgumentException {
        if (field == null) {
            return null;
        }
        Object fieldValue = null;
        boolean accessible = false;
        try {
            accessible = AccessibleObjectUtils.trySetAccessible(field);
            fieldValue = field.get(instance);
        }
        catch (IllegalAccessException e) {
            FieldUtils.handleIllegalAccessException(e, instance, field, accessible);
        }
        catch (IllegalArgumentException e) {
            FieldUtils.handleIllegalArgumentException(e, instance, field);
        }
        return (V)fieldValue;
    }

    @Nullable
    public static <V> V setFieldValue(Object instance, String fieldName, V value) throws IllegalStateException, IllegalArgumentException {
        return FieldUtils.setFieldValue(instance, FieldUtils.findField(instance, fieldName), value);
    }

    @Nullable
    public static <V> V setFieldValue(Object instance, Field field, V value) throws IllegalStateException, IllegalArgumentException {
        if (field == null) {
            return null;
        }
        Object previousValue = null;
        boolean accessible = false;
        try {
            accessible = AccessibleObjectUtils.trySetAccessible(field);
            previousValue = field.get(instance);
            if (!Objects.equals(previousValue, value)) {
                field.set(instance, value);
            }
        }
        catch (IllegalAccessException e) {
            FieldUtils.handleIllegalAccessException(e, instance, field, accessible);
        }
        catch (IllegalArgumentException e) {
            FieldUtils.handleIllegalArgumentException(e, instance, field);
        }
        return (V)previousValue;
    }

    public static void assertFieldMatchType(Object instance, String fieldName, Class<?> expectedType) throws IllegalArgumentException {
        Class<?> type = instance instanceof Class ? (Class<?>)instance : instance.getClass();
        Field field = FieldUtils.findField(type, fieldName);
        Class<?> fieldType = field.getType();
        if (!expectedType.isAssignableFrom(fieldType)) {
            String message = FormatUtils.format("The type['{}'] of field['{}'] in Class['{}'] can't match expected type['{}']", fieldType.getName(), fieldName, type.getName(), expectedType.getName());
            throw new IllegalArgumentException(message);
        }
    }

    static void handleIllegalAccessException(IllegalAccessException e, Object instance, Field field, boolean accessible) {
        String errorMessage = FormatUtils.format("The instance [object : {} , class : {} ] can't access the field[name : '{}' , type : {} , accessible : {}]", instance, ClassUtils.getTypeName(instance.getClass()), field.getName(), ClassUtils.getTypeName(field.getType()), accessible);
        if (logger.isTraceEnabled()) {
            logger.trace(errorMessage);
        }
        throw new IllegalStateException(errorMessage, e);
    }

    static void handleIllegalArgumentException(IllegalArgumentException e, Object instance, Field field) {
        String errorMessage = FormatUtils.format("The instance[object : {} , class : {}] can't match the field[name : '{}' , type : {}]", instance, ClassUtils.getTypeName(instance.getClass()), field.getName(), ClassUtils.getTypeName(field.getType()));
        if (logger.isTraceEnabled()) {
            logger.trace(errorMessage);
        }
        throw new IllegalArgumentException(errorMessage, e);
    }

    private FieldUtils() {
    }
}

