/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.lang.Deprecation;
import io.microsphere.reflect.ExecutableDefinition;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Version;
import java.lang.reflect.Method;

public class MethodDefinition
extends ExecutableDefinition<Method> {
    public MethodDefinition(String since, String declaredClassName, String methodName, String ... parameterClassNames) {
        this(since, (Deprecation)null, declaredClassName, methodName, parameterClassNames);
    }

    public MethodDefinition(String since, Deprecation deprecation, String declaredClassName, String methodName, String ... parameterClassNames) {
        this(Version.of(since), deprecation, declaredClassName, methodName, parameterClassNames);
    }

    public MethodDefinition(Version since, String declaredClassName, String methodName, String ... parameterClassNames) {
        this(since, (Deprecation)null, declaredClassName, methodName, parameterClassNames);
    }

    public MethodDefinition(Version since, Deprecation deprecation, String declaredClassName, String methodName, String ... parameterClassNames) {
        super(since, deprecation, declaredClassName, methodName, parameterClassNames);
    }

    @Nonnull
    public String getMethodName() {
        return super.getName();
    }

    @Nullable
    public Method getMethod() {
        return (Method)super.getMember();
    }

    @Override
    protected Method resolveMember() {
        return MethodUtils.findMethod(super.getDeclaredClass(), this.getMethodName(), super.getParameterTypes());
    }

    public <R> R invoke(Object instance, Object ... args) throws IllegalStateException, IllegalArgumentException, RuntimeException {
        return MethodUtils.invokeMethod(instance, this.getMethod(), args);
    }

    @Override
    public String toString() {
        return "MethodDefinition{since=" + this.since + ", deprecation=" + this.deprecation + ", declaredClassName='" + super.getDeclaredClassName() + '\'' + ", declaredClass=" + super.getDeclaredClass() + ", methodName='" + this.getMethodName() + '\'' + ", method=" + this.getMethod() + ", parameterClassName=" + ArrayUtils.arrayToString(this.parameterClassNames) + ", parameterTypes=" + ArrayUtils.arrayToString(super.getParameterTypes()) + '}';
    }
}

