/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.util.ArrayUtils;
import java.lang.reflect.Type;
import java.util.Objects;

public class MultipleType {
    private final Type[] types;

    private MultipleType(Type ... types) {
        this.types = types;
    }

    public int hashCode() {
        return Objects.hash(this.types);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleType that = (MultipleType)o;
        return ArrayUtils.arrayEquals(this.types, that.types);
    }

    public String toString() {
        return "MultipleType : " + ArrayUtils.arrayToString(this.types);
    }

    public static MultipleType of(Type one, Type two) {
        return new MultipleType(one, two);
    }

    public static MultipleType of(Type one, Type two, Type ... others) {
        Type[] oneAndTwo = ArrayUtils.ofArray(one, two);
        Type[] types = ArrayUtils.combineArray(oneAndTwo, new Type[][]{others});
        return new MultipleType(types);
    }
}

