/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.lang.Deprecation;
import io.microsphere.util.Assert;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.Version;
import java.io.Serializable;
import java.util.Objects;

public abstract class ReflectiveDefinition
implements Serializable {
    private static final long serialVersionUID = 3266384797780485350L;
    @Nonnull
    protected final Version since;
    @Nullable
    protected final Deprecation deprecation;
    @Nonnull
    protected final String className;
    private transient boolean resolved;
    @Nullable
    private transient Class<?> resolvedClass;

    public ReflectiveDefinition(@Nonnull String since, @Nonnull String className) {
        this(since, null, className);
    }

    public ReflectiveDefinition(@Nonnull String since, @Nullable Deprecation deprecation, @Nonnull String className) {
        this(Version.ofVersion(since), deprecation, className);
    }

    public ReflectiveDefinition(@Nonnull Version since, @Nonnull String className) {
        this(since, null, className);
    }

    public ReflectiveDefinition(@Nonnull Version since, @Nullable Deprecation deprecation, @Nonnull String className) {
        Assert.assertNotNull((Object)since, () -> "The 'since' version must not be null.");
        Assert.assertNotBlank(className, () -> "The class name must not be null.");
        this.since = since;
        this.deprecation = deprecation;
        this.className = className;
        this.resolved = false;
    }

    @Nonnull
    public final Version getSince() {
        return this.since;
    }

    @Nullable
    public final Deprecation getDeprecation() {
        return this.deprecation;
    }

    @Nonnull
    public final String getClassName() {
        return this.className;
    }

    @Nullable
    public final Class<?> getResolvedClass() {
        if (!this.resolved && this.resolvedClass == null) {
            ClassLoader classLoader = ClassLoaderUtils.getClassLoader(this.getClass());
            this.resolvedClass = ClassLoaderUtils.resolveClass(this.className, classLoader, true);
            this.resolved = true;
        }
        return this.resolvedClass;
    }

    public final boolean isDeprecated() {
        return this.deprecation != null;
    }

    public abstract boolean isPresent();

    public boolean equals(Object o) {
        if (!(o instanceof ReflectiveDefinition)) {
            return false;
        }
        ReflectiveDefinition that = (ReflectiveDefinition)o;
        return this.since.equals(that.since) && Objects.equals(this.deprecation, that.deprecation) && this.className.equals(that.className);
    }

    public int hashCode() {
        return Objects.hash(this.since, this.deprecation, this.className);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{since=" + this.since + ", deprecation=" + this.deprecation + ", className='" + this.className + "'" + ", resolvedClass=" + this.getResolvedClass() + '}';
    }
}

