/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.reflect;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.ListUtils;
import io.microsphere.collection.Lists;
import io.microsphere.collection.MapUtils;
import io.microsphere.lang.function.Predicates;
import io.microsphere.lang.function.Streams;
import io.microsphere.reflect.MultipleType;
import io.microsphere.reflect.generics.TypeArgument;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Assert;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.TypeFinder;
import io.microsphere.util.Utils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public abstract class TypeUtils
implements Utils {
    public static final Predicate<? super Type> NON_OBJECT_TYPE_FILTER = t -> t != null && !TypeUtils.isObjectType(t);
    public static final Predicate<? super Class<?>> NON_OBJECT_CLASS_FILTER = NON_OBJECT_TYPE_FILTER;
    public static final Predicate<? super Type> TYPE_VARIABLE_FILTER = TypeUtils::isTypeVariable;
    public static final Predicate<? super Type> PARAMETERIZED_TYPE_FILTER = TypeUtils::isParameterizedType;
    public static final Predicate<? super Type> WILDCARD_TYPE_FILTER = TypeUtils::isWildcardType;
    public static final Predicate<? super Type> GENERIC_ARRAY_TYPE_FILTER = TypeUtils::isGenericArrayType;
    public static final String RESOLVED_GENERIC_TYPES_CACHE_SIZE_PROPERTY_NAME = "microsphere.reflect.resolved-generic-types.cache.size";
    private static final ConcurrentMap<MultipleType, List<Type>> resolvedGenericTypesCache = MapUtils.newConcurrentHashMap(Integer.getInteger("microsphere.reflect.resolved-generic-types.cache.size", 256));

    public static boolean isClass(Object type) {
        return type instanceof Class;
    }

    public static boolean isObjectClass(Class<?> klass) {
        return TypeUtils.isObjectType(klass);
    }

    public static boolean isObjectType(Object type) {
        return type == Object.class;
    }

    public static boolean isParameterizedType(Object type) {
        return type instanceof ParameterizedType;
    }

    public static boolean isTypeVariable(Object type) {
        return type instanceof TypeVariable;
    }

    public static boolean isWildcardType(Object type) {
        return type instanceof WildcardType;
    }

    public static boolean isGenericArrayType(Object type) {
        return type instanceof GenericArrayType;
    }

    public static boolean isActualType(Type type) {
        return TypeUtils.isClass(type) || TypeUtils.isParameterizedType(type);
    }

    @Nullable
    public static Type getRawType(Type type) {
        if (TypeUtils.isParameterizedType(type)) {
            return ((ParameterizedType)type).getRawType();
        }
        return type;
    }

    @Nullable
    public static Class<?> getRawClass(Type type) {
        Type rawType = TypeUtils.getRawType(type);
        if (TypeUtils.isClass(rawType)) {
            return (Class)rawType;
        }
        return null;
    }

    public static boolean isAssignableFrom(Type superType, Type targetType) {
        Class<?> superClass = TypeUtils.asClass(superType);
        return TypeUtils.isAssignableFrom(superClass, targetType);
    }

    public static boolean isAssignableFrom(Class<?> superClass, Type targetType) {
        Class<?> targetClass = TypeUtils.asClass(targetType);
        return TypeUtils.isAssignableFrom(superClass, targetClass);
    }

    protected static boolean isAssignableFrom(Class<?> superType, Class<?> targetType) {
        return ClassUtils.isAssignableFrom(superType, targetType);
    }

    @Nonnull
    public static List<Type> resolveActualTypeArguments(Type type, Type baseType) {
        return Collections.unmodifiableList(TypeUtils.doResolveActualTypeArguments(type, baseType));
    }

    @Nonnull
    public static Type resolveActualTypeArgument(Type type, Type baseType, int index) {
        return TypeUtils.doResolveActualTypeArguments(type, baseType).get(index);
    }

    @Nonnull
    public static List<Class> resolveActualTypeArgumentClasses(Type type, Type baseType) {
        return Collections.unmodifiableList(TypeUtils.doResolveActualTypeArgumentClasses(type, baseType));
    }

    @Nullable
    public static Class resolveActualTypeArgumentClass(Type type, Class baseType, int index) {
        return TypeUtils.asClass(TypeUtils.resolveActualTypeArgument(type, baseType, index));
    }

    protected static List<Class> doResolveActualTypeArgumentClasses(Type type, Type baseType) {
        return TypeUtils.doResolveActualTypeArguments(type, baseType).stream().map(TypeUtils::asClass).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected static List<Type> doResolveActualTypeArguments(Type type, Type baseType) {
        Class<?> baseClass = TypeUtils.asClass(baseType);
        return TypeUtils.doResolveActualTypeArguments(type, baseClass);
    }

    public static List<Type> resolveActualTypeArguments(Type type, Class baseClass) {
        return Collections.unmodifiableList(TypeUtils.doResolveActualTypeArguments(type, baseClass));
    }

    protected static List<Type> doResolveActualTypeArguments(Type type, Class baseClass) {
        if (type == null || baseClass == null) {
            return Collections.emptyList();
        }
        return resolvedGenericTypesCache.computeIfAbsent(MultipleType.of(type, baseClass), mt -> {
            TypeVariable<Class<T>>[] baseTypeParameters = baseClass.getTypeParameters();
            int baseTypeParametersLength = baseTypeParameters.length;
            if (baseTypeParametersLength == 0) {
                return Collections.emptyList();
            }
            Class<?> klass = TypeUtils.asClass(type);
            boolean sameClass = baseClass.equals(klass);
            if (sameClass) {
                return TypeUtils.doResolveActualTypeArgumentsInFastPath(type);
            }
            if (!baseClass.isAssignableFrom(klass)) {
                return Collections.emptyList();
            }
            Predicate<Type> baseClassFilter = t -> TypeUtils.isAssignableFrom(baseClass, t);
            List<Type> hierarchicalTypes = Streams.filterList(TypeUtils.doGetHierarchicalTypes(type), baseClassFilter);
            int hierarchicalTypesSize = hierarchicalTypes.size();
            Map<Class, TypeArgument[]> typeArgumentsMap = TypeUtils.resolveTypeArgumentsMap(type, hierarchicalTypes, hierarchicalTypesSize, baseClass, baseTypeParameters);
            Type[] actualTypeArguments = new Type[baseTypeParametersLength];
            int actualTypeArgumentsCount = 0;
            for (TypeArgument[] typeArguments : typeArgumentsMap.values()) {
                for (int i = 0; i < baseTypeParametersLength; ++i) {
                    Type actualTypeArgument;
                    TypeArgument typeArgument = typeArguments[i];
                    if (typeArgument == null) continue;
                    actualTypeArguments[i] = actualTypeArgument = typeArgument.getType();
                    ++actualTypeArgumentsCount;
                }
                if (actualTypeArgumentsCount != baseTypeParametersLength) continue;
                break;
            }
            return Lists.ofList(actualTypeArguments);
        });
    }

    static List<Type> doResolveActualTypeArgumentsInFastPath(Type type) {
        ParameterizedType pType = TypeUtils.asParameterizedType(type);
        if (pType != null) {
            Type[] actualTypeArguments = pType.getActualTypeArguments();
            int actualTypeArgumentsLength = actualTypeArguments.length;
            ArrayList<Type> actualTypeArgumentsList = ListUtils.newArrayList(actualTypeArgumentsLength);
            for (int i = 0; i < actualTypeArgumentsLength; ++i) {
                Type actualTypeArgument = actualTypeArguments[i];
                if (!TypeUtils.isActualType(actualTypeArgument)) continue;
                actualTypeArgumentsList.add(actualTypeArgument);
            }
            return actualTypeArgumentsList;
        }
        return Collections.emptyList();
    }

    private static Map<Class, TypeArgument[]> resolveTypeArgumentsMap(Type type, List<Type> hierarchicalTypes, int hierarchicalTypesSize, Class baseClass, TypeVariable<Class>[] baseTypeParameters) {
        int size = hierarchicalTypesSize + 1;
        LinkedHashMap<Class, TypeArgument[]> typeArgumentsMap = MapUtils.newLinkedHashMap(size);
        for (int i = hierarchicalTypesSize - 1; i > -1; --i) {
            Type hierarchicalType = hierarchicalTypes.get(i);
            TypeUtils.resolveTypeArgumentsMap(hierarchicalType, hierarchicalTypes, i, hierarchicalTypesSize, typeArgumentsMap, baseClass, baseTypeParameters);
        }
        TypeUtils.resolveTypeArgumentsMap(type, hierarchicalTypes, -1, hierarchicalTypesSize, typeArgumentsMap, baseClass, baseTypeParameters);
        return typeArgumentsMap;
    }

    private static void resolveTypeArgumentsMap(Type type, List<Type> hierarchicalTypes, int index, int hierarchicalTypesSize, Map<Class, TypeArgument[]> typeArgumentsMap, Class baseClass, TypeVariable<Class>[] baseTypeParameters) {
        ParameterizedType pType = TypeUtils.asParameterizedType(type);
        if (pType != null) {
            TypeUtils.resolveTypeArgumentsMap(pType, hierarchicalTypes, index, hierarchicalTypesSize, typeArgumentsMap, baseClass, baseTypeParameters);
        }
    }

    private static void resolveTypeArgumentsMap(ParameterizedType type, List<Type> hierarchicalTypes, int index, int hierarchicalTypesSize, Map<Class, TypeArgument[]> typeArgumentsMap, Class baseClass, TypeVariable<Class>[] baseTypeParameters) {
        Class<?> klass = TypeUtils.asClass(type);
        int baseTypeArgumentsLength = baseTypeParameters.length;
        TypeArgument[] typeArguments = TypeUtils.newTypeArguments(klass, typeArgumentsMap, baseTypeArgumentsLength);
        Type[] actualTypeArguments = type.getActualTypeArguments();
        int actualTypeArgumentsLength = actualTypeArguments.length;
        int length = Math.min(actualTypeArgumentsLength, baseTypeArgumentsLength);
        int actualTypesCount = 0;
        for (int i = 0; i < length; ++i) {
            Type actualTypeArgument = actualTypeArguments[i];
            if (!TypeUtils.isActualType(actualTypeArgument)) continue;
            ++actualTypesCount;
            typeArguments[i] = TypeArgument.create(actualTypeArgument, i);
        }
        if (klass == baseClass) {
            return;
        }
        if (actualTypesCount < baseTypeArgumentsLength) {
            TypeVariable<Class<?>>[] typeParameters = klass.getTypeParameters();
            int typeParametersLength = typeParameters.length;
            for (int superTypeIndex = index + 1; superTypeIndex < hierarchicalTypesSize; ++superTypeIndex) {
                Type superType = hierarchicalTypes.get(superTypeIndex);
                Class<?> superClass = TypeUtils.asClass(superType);
                TypeVariable<Class<?>>[] superTypeParameters = superClass.getTypeParameters();
                int superTypeParametersLength = superTypeParameters.length;
                TypeArgument[] superTypeArguments = TypeUtils.getTypeArguments(superClass, typeArgumentsMap);
                if (superTypeArguments == null) continue;
                for (int typeParameterIndex = 0; typeParameterIndex < typeParametersLength; ++typeParameterIndex) {
                    TypeVariable<Class<?>> typeParameter = typeParameters[typeParameterIndex];
                    String typeParameterName = typeParameter.getName();
                    for (int superTypeParameterIndex = 0; superTypeParameterIndex < superTypeParametersLength; ++superTypeParameterIndex) {
                        TypeVariable<Class<?>> superTypeParameter = superTypeParameters[superTypeParameterIndex];
                        String superTypeParameterName = superTypeParameter.getName();
                        if (!typeParameterName.equals(superTypeParameterName)) continue;
                        superTypeArguments[superTypeParameterIndex] = typeArguments[typeParameterIndex];
                    }
                }
            }
        }
    }

    private static TypeArgument[] newTypeArguments(Class klass, Map<Class, TypeArgument[]> typeArgumentsMap, int typeArgumentsLength) {
        return typeArgumentsMap.computeIfAbsent(klass, t -> new TypeArgument[typeArgumentsLength]);
    }

    private static TypeArgument[] getTypeArguments(Class klass, Map<Class, TypeArgument[]> typeArgumentsMap) {
        return typeArgumentsMap.get(klass);
    }

    @Nonnull
    public static List<Type> getAllGenericSuperclasses(Type type) {
        return TypeUtils.findAllGenericSuperclasses(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    public static List<Type> getAllGenericInterfaces(Type type) {
        return TypeUtils.findAllGenericInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    public static List<ParameterizedType> getParameterizedTypes(Type type) {
        return TypeUtils.findParameterizedTypes(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    public static List<ParameterizedType> getAllParameterizedTypes(Type type) {
        return TypeUtils.findAllParameterizedTypes(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    public static List<Type> getHierarchicalTypes(Type type) {
        return TypeUtils.findHierarchicalTypes(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    public static List<Type> getAllTypes(Type type) {
        return TypeUtils.findAllTypes(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    public static List<Type> findAllGenericSuperclasses(Type type, Predicate<? super Type> ... typeFilters) {
        return TypeUtils.findTypes(type, false, true, true, false, typeFilters);
    }

    @Nonnull
    public static List<Type> findAllGenericInterfaces(Type type, Predicate<? super Type> ... typeFilters) {
        return TypeUtils.findTypes(type, false, true, false, true, typeFilters);
    }

    @Nonnull
    public static List<ParameterizedType> findParameterizedTypes(Type type, Predicate<? super ParameterizedType> ... typeFilters) {
        return TypeUtils.findTypes(type, true, false, true, true, TypeUtils.parameterizedTypePredicate(typeFilters));
    }

    @Nonnull
    public static List<ParameterizedType> findAllParameterizedTypes(Type type, Predicate<? super ParameterizedType> ... typeFilters) {
        return TypeUtils.findAllTypes(type, TypeUtils.parameterizedTypePredicate(typeFilters));
    }

    @Nonnull
    public static List<Type> findHierarchicalTypes(Type type, Predicate<? super Type> ... typeFilters) {
        return TypeUtils.findTypes(type, false, true, true, true, typeFilters);
    }

    @Nonnull
    public static List<Type> findAllTypes(Type type, Predicate<? super Type> ... typeFilters) {
        return TypeUtils.findTypes(type, true, true, true, true, typeFilters);
    }

    protected static Predicate parameterizedTypePredicate(Predicate<? super ParameterizedType> ... predicates) {
        Predicate<? super ParameterizedType> predicate = Predicates.and(predicates);
        return PARAMETERIZED_TYPE_FILTER.and(predicate);
    }

    protected static List<Type> findTypes(Type type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeGenericSuperclass, boolean includeGenericInterfaces, Predicate<? super Type> ... typeFilters) {
        if (type == null || TypeUtils.isObjectType(type)) {
            return Collections.emptyList();
        }
        return TypeFinder.genericTypeFinder(type, includeSelf, includeHierarchicalTypes, includeGenericSuperclass, includeGenericInterfaces).findTypes(typeFilters);
    }

    protected static List<Type> doGetHierarchicalTypes(Type type) {
        return TypeFinder.genericTypeFinder(type, false, true, true, true).findTypes(Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nullable
    public static String getClassName(Type type) {
        Type rawType = TypeUtils.getRawType(type);
        if (rawType == null) {
            return null;
        }
        return rawType.getTypeName();
    }

    @Nonnull
    public static Set<String> getClassNames(Iterable<? extends Type> types) {
        return StreamSupport.stream(types.spliterator(), false).map(TypeUtils::getClassName).collect(Collectors.toSet());
    }

    @Nonnull
    public static List<Type> resolveTypeArguments(Class<?> targetClass) {
        if (targetClass == null || targetClass.isPrimitive() || targetClass.isArray()) {
            return Collections.emptyList();
        }
        LinkedList<Type> typeArguments = ListUtils.newLinkedList();
        while (targetClass != null && targetClass != Object.class) {
            typeArguments.addAll(TypeUtils.resolveTypeArguments(targetClass.getGenericSuperclass()));
            typeArguments.addAll(TypeUtils.resolveTypeArguments(targetClass.getGenericInterfaces()));
            targetClass = targetClass.getSuperclass();
        }
        return typeArguments.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(typeArguments);
    }

    protected static List<Type> resolveTypeArguments(Type ... types) {
        int length = ArrayUtils.length(types);
        if (length < 1) {
            return Collections.emptyList();
        }
        LinkedList<Type> typeArguments = ListUtils.newLinkedList();
        for (int i = 0; i < length; ++i) {
            typeArguments.addAll(TypeUtils.getActualTypeArguments(types[i]));
        }
        return typeArguments;
    }

    protected static List<Type> getActualTypeArguments(Type type) {
        if (TypeUtils.isObjectType(type)) {
            return Collections.emptyList();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return Lists.ofList(pType.getActualTypeArguments());
        }
        return Collections.emptyList();
    }

    @Nonnull
    public static List<Class<?>> resolveTypeArgumentClasses(Class<?> targetClass) {
        List<Type> typeArguments = TypeUtils.resolveTypeArguments(targetClass);
        return Collections.unmodifiableList(typeArguments.stream().map(TypeUtils::asClass).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Nullable
    public static Class<?> asClass(Type type) {
        ParameterizedType parameterizedType;
        Class<?> targetClass = TypeUtils.asClass0(type);
        if (targetClass == null && (parameterizedType = TypeUtils.asParameterizedType(type)) != null) {
            targetClass = TypeUtils.asClass(parameterizedType.getRawType());
        }
        return targetClass;
    }

    private static Class<?> asClass0(Type type) {
        return TypeUtils.isClass(type) ? (Class)type : null;
    }

    @Nullable
    public static GenericArrayType asGenericArrayType(Type type) {
        if (type instanceof GenericArrayType) {
            return (GenericArrayType)type;
        }
        return null;
    }

    @Nullable
    public static ParameterizedType asParameterizedType(Type type) {
        if (TypeUtils.isParameterizedType(type)) {
            return (ParameterizedType)type;
        }
        return null;
    }

    @Nullable
    public static TypeVariable asTypeVariable(Type type) {
        if (TypeUtils.isTypeVariable(type)) {
            return (TypeVariable)type;
        }
        return null;
    }

    @Nullable
    public static WildcardType asWildcardType(Type type) {
        if (TypeUtils.isWildcardType(type)) {
            return (WildcardType)type;
        }
        return null;
    }

    @Nullable
    public static Type getComponentType(Type type) {
        GenericArrayType genericArrayType = TypeUtils.asGenericArrayType(type);
        if (genericArrayType != null) {
            return genericArrayType.getGenericComponentType();
        }
        Class<?> klass = TypeUtils.asClass(type);
        return klass != null ? klass.getComponentType() : null;
    }

    @Nullable
    public static String getTypeName(@Nullable Type type) {
        return type == null ? null : type.getTypeName();
    }

    @Nonnull
    public static String[] getTypeNames(Type ... types) throws IllegalArgumentException {
        if (ArrayUtils.isEmpty(types)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        Assert.assertNoNullElements((Object[])types, "Any element of 'types' must not be null");
        return (String[])Stream.of(types).map(TypeUtils::getTypeName).toArray(String[]::new);
    }

    private TypeUtils() {
    }
}

