/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.text;

import io.microsphere.util.StringUtils;
import io.microsphere.util.Utils;

public abstract class FormatUtils
implements Utils {
    public static final String DEFAULT_PLACEHOLDER = "{}";

    public static String format(String pattern, Object ... args) {
        return FormatUtils.formatWithPlaceholder(pattern, DEFAULT_PLACEHOLDER, args);
    }

    public static String formatWithPlaceholder(String pattern, String placeholder, Object ... args) {
        int argsLength;
        if (StringUtils.isBlank(pattern)) {
            return pattern;
        }
        int offset = placeholder.length();
        int n = argsLength = args == null ? 0 : args.length;
        if (argsLength == 0) {
            return pattern;
        }
        StringBuilder stringBuilder = new StringBuilder(pattern);
        int index = -1;
        for (int i = 0; i < argsLength && (index = stringBuilder.indexOf(placeholder)) != -1; ++i) {
            String value = String.valueOf(args[i]);
            stringBuilder.replace(index, index + offset, value);
        }
        return stringBuilder.toString();
    }

    private FormatUtils() {
    }
}

