/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.Lists;
import io.microsphere.collection.MapUtils;
import io.microsphere.lang.function.Predicates;
import io.microsphere.lang.function.Streams;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Native;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public abstract class AnnotationUtils
implements Utils {
    @Nonnull
    public static final List<Class<? extends Annotation>> NATIVE_ANNOTATION_TYPES = Lists.ofList(new Class[]{Target.class, Retention.class, Documented.class, Inherited.class, Native.class, Repeatable.class});
    static final Predicate<? super Method> NON_OBJECT_METHOD_PREDICATE = Predicates.and(Objects::nonNull, MethodUtils.OBJECT_METHOD_PREDICATE.negate());
    static final Predicate<? super Method> ANNOTATION_INTERFACE_METHOD_PREDICATE = AnnotationUtils::isAnnotationInterfaceMethod;
    static final Predicate<? super Method> NON_ANNOTATION_INTERFACE_METHOD_PREDICATE = ANNOTATION_INTERFACE_METHOD_PREDICATE.negate();
    static final Predicate<? super Method> ANNOTATION_DECLARED_METHOD_PREDICATE = Predicates.and(NON_OBJECT_METHOD_PREDICATE, NON_ANNOTATION_INTERFACE_METHOD_PREDICATE);
    public static final String CALLER_SENSITIVE_ANNOTATION_CLASS_NAME = "jdk.internal.reflect.CallerSensitive";
    public static final Class<? extends Annotation> CALLER_SENSITIVE_ANNOTATION_CLASS = ClassLoaderUtils.resolveClass("jdk.internal.reflect.CallerSensitive");
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = ArrayUtils.EMPTY_ANNOTATION_ARRAY;

    public static boolean isType(AnnotatedElement annotatedElement) {
        return annotatedElement instanceof Class;
    }

    public static boolean isSameType(Annotation annotation, Class<? extends Annotation> annotationType) {
        if (annotation == null || annotationType == null) {
            return false;
        }
        return annotation.annotationType() == annotationType;
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return AnnotationUtils.findAnnotation(annotatedElement, a -> AnnotationUtils.isSameType(a, annotationType));
    }

    @Nullable
    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Predicate<? super Annotation> ... annotationFilters) {
        return (A)Streams.filterFirst(AnnotationUtils.findAllDeclaredAnnotations(annotatedElement, new Predicate[0]), annotationFilters);
    }

    public static boolean isMetaAnnotation(Annotation annotation, Class<? extends Annotation> metaAnnotationType) {
        if (annotation == null || metaAnnotationType == null) {
            return false;
        }
        return AnnotationUtils.isMetaAnnotation(annotation.annotationType(), metaAnnotationType);
    }

    public static boolean isMetaAnnotation(Annotation annotation, Class<? extends Annotation> ... metaAnnotationTypes) {
        if (annotation == null || ArrayUtils.isEmpty(metaAnnotationTypes)) {
            return false;
        }
        return AnnotationUtils.isMetaAnnotation(annotation, Lists.ofList(metaAnnotationTypes));
    }

    public static boolean isMetaAnnotation(Annotation annotation, Iterable<Class<? extends Annotation>> metaAnnotationTypes) {
        if (annotation == null) {
            return false;
        }
        return AnnotationUtils.isMetaAnnotation(annotation.annotationType(), metaAnnotationTypes);
    }

    public static boolean isMetaAnnotation(Class<? extends Annotation> annotationType, Class<? extends Annotation> metaAnnotationType) {
        if (annotationType == null || metaAnnotationType == null || NATIVE_ANNOTATION_TYPES.contains(annotationType)) {
            return false;
        }
        for (Annotation annotation : annotationType.getDeclaredAnnotations()) {
            if (AnnotationUtils.isSameType(annotation, metaAnnotationType)) {
                return true;
            }
            if (!AnnotationUtils.isMetaAnnotation(annotation.annotationType(), metaAnnotationType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMetaAnnotation(Class<? extends Annotation> annotationType, Class<? extends Annotation> ... metaAnnotationTypes) {
        return AnnotationUtils.isMetaAnnotation(annotationType, Lists.ofList(metaAnnotationTypes));
    }

    public static boolean isMetaAnnotation(Class<? extends Annotation> annotationType, Iterable<Class<? extends Annotation>> metaAnnotationTypes) {
        if (annotationType == null || metaAnnotationTypes == null || NATIVE_ANNOTATION_TYPES.contains(annotationType)) {
            return false;
        }
        for (Class<? extends Annotation> metaAnnotationType : metaAnnotationTypes) {
            if (!AnnotationUtils.isMetaAnnotation(annotationType, metaAnnotationType)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public static List<Annotation> getAllDeclaredAnnotations(AnnotatedElement annotatedElement) {
        return AnnotationUtils.findAllDeclaredAnnotations(annotatedElement, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    public static List<Annotation> getDeclaredAnnotations(AnnotatedElement annotatedElement) {
        return AnnotationUtils.findDeclaredAnnotations(annotatedElement, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    public static List<Annotation> findAllDeclaredAnnotations(AnnotatedElement annotatedElement, Predicate<? super Annotation> ... annotationsToFilter) {
        if (AnnotationUtils.isType(annotatedElement)) {
            return AnnotationUtils.findAllDeclaredAnnotations((Class)annotatedElement, annotationsToFilter);
        }
        return AnnotationUtils.findDeclaredAnnotations(annotatedElement, annotationsToFilter);
    }

    @Nonnull
    public static List<Annotation> findAllDeclaredAnnotations(Class<?> type, Predicate<? super Annotation> ... annotationsToFilter) {
        if (type == null) {
            return Collections.emptyList();
        }
        LinkedList<Annotation> allAnnotations = new LinkedList<Annotation>();
        List<Class<?>> allInheritedClasses = ClassUtils.findAllInheritedClasses(type, TypeUtils.NON_OBJECT_CLASS_FILTER);
        allAnnotations.addAll(AnnotationUtils.getDeclaredAnnotations(type));
        for (Class<?> inheritedClass : allInheritedClasses) {
            allAnnotations.addAll(AnnotationUtils.getDeclaredAnnotations(inheritedClass));
        }
        return AnnotationUtils.filterAnnotations(allAnnotations, annotationsToFilter);
    }

    @Nonnull
    public static List<Annotation> findDeclaredAnnotations(AnnotatedElement annotatedElement, Predicate<? super Annotation> ... annotationsToFilter) {
        if (annotatedElement == null) {
            return Collections.emptyList();
        }
        return AnnotationUtils.filterAnnotations(annotatedElement.getAnnotations(), annotationsToFilter);
    }

    @Nonnull
    public static List<Annotation> filterAnnotations(Annotation[] annotations, Predicate<? super Annotation> ... annotationsToFilter) {
        return ArrayUtils.isEmpty(annotations) ? Collections.emptyList() : AnnotationUtils.filterAnnotations(Lists.ofList(annotations), annotationsToFilter);
    }

    @Nonnull
    public static List<Annotation> filterAnnotations(List<Annotation> annotations, Predicate<? super Annotation> ... annotationsToFilter) {
        if (CollectionUtils.isEmpty(annotations)) {
            return Collections.emptyList();
        }
        if (ArrayUtils.isEmpty(annotationsToFilter)) {
            return Collections.unmodifiableList(annotations);
        }
        List<Annotation> filteredAnnotations = Streams.filterAll(annotations, annotationsToFilter);
        return CollectionUtils.isEmpty(filteredAnnotations) ? Collections.emptyList() : filteredAnnotations;
    }

    @Nullable
    public static <T> T findAttributeValue(Annotation[] annotations, String attributeName) {
        T attributeValue = null;
        for (Annotation annotation : annotations) {
            if (annotation != null && (attributeValue = (T)AnnotationUtils.getAttributeValue(annotation, attributeName)) != null) break;
        }
        return attributeValue;
    }

    @Nullable
    public static <T> T getAttributeValue(Annotation annotation, String attributeName) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        Method attributeMethod = MethodUtils.findMethod(annotationType, attributeName);
        return attributeMethod == null ? null : (T)MethodUtils.invokeMethod((Object)annotation, attributeMethod, new Object[0]);
    }

    @Nonnull
    public static Map<String, Object> getAttributesMap(Annotation annotation) {
        return AnnotationUtils.findAttributesMap(annotation, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    @Nonnull
    public static Map<String, Object> findAttributesMap(Annotation annotation, String ... attributeNamesToFilter) {
        return AnnotationUtils.findAttributesMap(annotation, method -> ArrayUtils.contains(attributeNamesToFilter, method.getName()));
    }

    @Nonnull
    public static Map<String, Object> findAttributesMap(Annotation annotation, Predicate<? super Method> ... attributesToFilter) {
        if (annotation == null) {
            return Collections.emptyMap();
        }
        Predicate predicate = Predicates.and(ANNOTATION_DECLARED_METHOD_PREDICATE, Predicates.and(attributesToFilter));
        List<Method> attributeMethods = MethodUtils.findMethods(annotation.annotationType(), predicate);
        return MapUtils.toFixedMap(attributeMethods, method -> MapUtils.immutableEntry(method.getName(), MethodUtils.invokeMethod((Object)annotation, method, new Object[0])));
    }

    public static boolean exists(Annotation[] annotations, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.exists(Lists.ofList(annotations), annotationType);
    }

    public static boolean exists(Collection<Annotation> annotations, Class<? extends Annotation> annotationType) {
        if (CollectionUtils.isEmpty(annotations)) {
            return false;
        }
        return AnnotationUtils.exists(annotations, annotationType);
    }

    public static boolean exists(Iterable<Annotation> annotations, Class<? extends Annotation> annotationType) {
        if (annotations == null || annotationType == null) {
            return false;
        }
        boolean found = false;
        for (Annotation annotation : annotations) {
            if (!Objects.equals(annotation.annotationType(), annotationType)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static boolean isAnnotationPresent(AnnotatedElement[] annotatedElements, Class<? extends Annotation> annotationType) {
        int length = ArrayUtils.length(annotatedElements);
        if (length < 1 || annotationType == null) {
            return false;
        }
        boolean annotated = false;
        for (int i = 0; i < length; ++i) {
            if (!AnnotationUtils.isAnnotationPresent(annotatedElements[i], annotationType)) continue;
            annotated = true;
            break;
        }
        return annotated;
    }

    public static boolean isAnnotationPresent(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType) {
        if (annotatedElement == null || annotationType == null) {
            return false;
        }
        return annotatedElement.isAnnotationPresent(annotationType);
    }

    public static boolean isAnnotationPresent(Annotation annotation, Class<? extends Annotation> annotationType) {
        if (annotation == null || annotationType == null) {
            return false;
        }
        return AnnotationUtils.isAnnotationPresent(annotation.annotationType(), annotationType);
    }

    public static boolean isAnnotationPresent(AnnotatedElement annotatedElement, Iterable<Class<? extends Annotation>> annotationTypes) {
        if (annotatedElement == null || annotationTypes == null) {
            return false;
        }
        boolean hasNext = false;
        boolean annotated = true;
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            hasNext = true;
            if (AnnotationUtils.isAnnotationPresent(annotatedElement, annotationType)) continue;
            annotated = false;
            break;
        }
        return hasNext & annotated;
    }

    public static boolean isAnnotationPresent(Annotation annotation, Iterable<Class<? extends Annotation>> annotationTypes) {
        if (annotation == null) {
            return false;
        }
        return AnnotationUtils.isAnnotationPresent(annotation.annotationType(), annotationTypes);
    }

    public static boolean isAnnotationInterfaceMethod(Method attributeMethod) {
        return attributeMethod != null && Annotation.class == attributeMethod.getDeclaringClass();
    }

    public static boolean isCallerSensitivePresent() {
        return CALLER_SENSITIVE_ANNOTATION_CLASS != null;
    }

    private AnnotationUtils() {
    }
}

