/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.collection.ListUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.Utils;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public abstract class ArrayUtils
implements Utils {
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final File[] EMPTY_FILE_ARRAY = new File[0];
    public static final URL[] EMPTY_URL_ARRAY = new URL[0];
    public static final Parameter[] EMPTY_PARAMETER_ARRAY = new Parameter[0];
    public static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    public static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];

    public static <T> T[] of(T ... values) {
        return ArrayUtils.ofArray(values);
    }

    public static boolean[] ofBooleans(boolean ... values) {
        return values;
    }

    public static byte[] ofBytes(byte ... values) {
        return values;
    }

    public static char[] ofChars(char ... values) {
        return values;
    }

    public static short[] ofShorts(short ... values) {
        return values;
    }

    public static int[] ofInts(int ... values) {
        return values;
    }

    public static long[] ofLongs(long ... values) {
        return values;
    }

    public static float[] ofFloats(float ... values) {
        return values;
    }

    public static double[] ofDoubles(double ... values) {
        return values;
    }

    public static <T> T[] ofArray(T ... values) {
        return values;
    }

    public static int length(boolean[] values) {
        return values == null ? 0 : values.length;
    }

    public static int length(byte[] values) {
        return values == null ? 0 : values.length;
    }

    public static int length(char[] values) {
        return values == null ? 0 : values.length;
    }

    public static int length(short[] values) {
        return values == null ? 0 : values.length;
    }

    public static int length(int[] values) {
        return values == null ? 0 : values.length;
    }

    public static int length(long[] values) {
        return values == null ? 0 : values.length;
    }

    public static int length(float[] values) {
        return values == null ? 0 : values.length;
    }

    public static int length(double[] values) {
        return values == null ? 0 : values.length;
    }

    public static <T> int length(T[] values) {
        return values == null ? 0 : values.length;
    }

    public static <T> int size(T[] values) {
        return ArrayUtils.length(values);
    }

    public static boolean isEmpty(boolean[] values) {
        return ArrayUtils.length(values) == 0;
    }

    public static boolean isEmpty(byte[] values) {
        return ArrayUtils.length(values) == 0;
    }

    public static boolean isEmpty(char[] values) {
        return ArrayUtils.length(values) == 0;
    }

    public static boolean isEmpty(short[] values) {
        return ArrayUtils.length(values) == 0;
    }

    public static boolean isEmpty(int[] values) {
        return ArrayUtils.length(values) == 0;
    }

    public static boolean isEmpty(long[] values) {
        return ArrayUtils.length(values) == 0;
    }

    public static boolean isEmpty(float[] values) {
        return ArrayUtils.length(values) == 0;
    }

    public static boolean isEmpty(double[] values) {
        return ArrayUtils.length(values) == 0;
    }

    public static <T> boolean isEmpty(T[] values) {
        return ArrayUtils.length(values) == 0;
    }

    public static boolean isNotEmpty(boolean[] values) {
        return !ArrayUtils.isEmpty(values);
    }

    public static boolean isNotEmpty(byte[] values) {
        return !ArrayUtils.isEmpty(values);
    }

    public static boolean isNotEmpty(char[] values) {
        return !ArrayUtils.isEmpty(values);
    }

    public static boolean isNotEmpty(short[] values) {
        return !ArrayUtils.isEmpty(values);
    }

    public static boolean isNotEmpty(int[] values) {
        return !ArrayUtils.isEmpty(values);
    }

    public static boolean isNotEmpty(long[] values) {
        return !ArrayUtils.isEmpty(values);
    }

    public static boolean isNotEmpty(float[] values) {
        return !ArrayUtils.isEmpty(values);
    }

    public static boolean isNotEmpty(double[] values) {
        return !ArrayUtils.isEmpty(values);
    }

    public static <T> boolean isNotEmpty(T[] values) {
        return !ArrayUtils.isEmpty(values);
    }

    public static boolean arrayEquals(boolean[] a, boolean[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean arrayEquals(byte[] a, byte[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean arrayEquals(char[] a, char[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean arrayEquals(short[] a, short[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean arrayEquals(int[] a, int[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean arrayEquals(long[] a, long[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean arrayEquals(float[] a, float[] b) {
        return Arrays.equals(a, b);
    }

    public static boolean arrayEquals(double[] a, double[] b) {
        return Arrays.equals(a, b);
    }

    public static <T> boolean arrayEquals(T[] a, T[] b) {
        return Arrays.equals(a, b);
    }

    public static <E> E[] asArray(Enumeration<E> enumeration, Class<?> componentType) {
        return ArrayUtils.asArray(Collections.list(enumeration), componentType);
    }

    public static <E> E[] asArray(Iterable<E> elements, Class<?> componentType) {
        return ArrayUtils.asArray(ListUtils.newArrayList(elements), componentType);
    }

    public static <E> E[] asArray(Collection<E> collection, Class<?> componentType) {
        return collection.toArray(ArrayUtils.newArray(componentType, 0));
    }

    public static <E> E[] newArray(Class<?> componentType, int length) {
        return (Object[])Array.newInstance(componentType, length);
    }

    public static <E> E[] combine(E one, E ... others) {
        int othersLength = ArrayUtils.length(others);
        Class<?> oneType = one.getClass();
        boolean oneIsArray = ClassUtils.isArray(oneType);
        if (oneIsArray) {
            return ArrayUtils.combineArray((Object[])oneType.cast(one), new Object[][]{others});
        }
        Class<?> componentType = oneType;
        int length = 1 + othersLength;
        E[] values = ArrayUtils.newArray(componentType, length);
        values[0] = one;
        System.arraycopy(others, 0, values, 1, othersLength);
        return values;
    }

    public static <E> E[] combine(E[] one, E[] ... others) {
        return ArrayUtils.combineArray(one, others);
    }

    public static <E> E[] combineArray(E[] one, E[] ... others) {
        int oneSize;
        int othersSize = ArrayUtils.length(others);
        if (othersSize < 1) {
            return one;
        }
        int size = oneSize = ArrayUtils.length(one);
        for (int i = 0; i < othersSize; ++i) {
            E[] other = others[i];
            int otherLength = ArrayUtils.length(other);
            size += otherLength;
        }
        Class<?> componentType = one.getClass().getComponentType();
        E[] newArray = ArrayUtils.newArray(componentType, size);
        int pos = 0;
        System.arraycopy(one, 0, newArray, pos, oneSize);
        pos += oneSize;
        for (int i = 0; i < othersSize; ++i) {
            E[] other = others[i];
            int otherLength = ArrayUtils.length(other);
            if (otherLength <= 0) continue;
            System.arraycopy(other, 0, newArray, pos, otherLength);
            pos += otherLength;
        }
        return newArray;
    }

    public static void forEach(boolean[] values, Consumer<Boolean> consumer) {
        ArrayUtils.forEach(values, (Integer i, Boolean e) -> consumer.accept((Boolean)e));
    }

    public static void forEach(byte[] values, Consumer<Byte> consumer) {
        ArrayUtils.forEach(values, (Integer i, Byte e) -> consumer.accept((Byte)e));
    }

    public static void forEach(char[] values, Consumer<Character> consumer) {
        ArrayUtils.forEach(values, (Integer i, Character e) -> consumer.accept((Character)e));
    }

    public static void forEach(short[] values, Consumer<Short> consumer) {
        ArrayUtils.forEach(values, (Integer i, Short e) -> consumer.accept((Short)e));
    }

    public static void forEach(int[] values, Consumer<Integer> consumer) {
        ArrayUtils.forEach(values, (Integer i, Integer e) -> consumer.accept((Integer)e));
    }

    public static void forEach(long[] values, Consumer<Long> consumer) {
        ArrayUtils.forEach(values, (Integer i, Long e) -> consumer.accept((Long)e));
    }

    public static void forEach(float[] values, Consumer<Float> consumer) {
        ArrayUtils.forEach(values, (Integer i, Float e) -> consumer.accept((Float)e));
    }

    public static void forEach(double[] values, Consumer<Double> consumer) {
        ArrayUtils.forEach(values, (Integer i, Double e) -> consumer.accept((Double)e));
    }

    public static <T> void forEach(T[] values, Consumer<T> consumer) {
        ArrayUtils.forEach(values, (Integer i, T e) -> consumer.accept(e));
    }

    public static void forEach(boolean[] values, BiConsumer<Integer, Boolean> indexedElementConsumer) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            Boolean value = values[i];
            indexedElementConsumer.accept(i, value);
        }
    }

    public static void forEach(byte[] values, BiConsumer<Integer, Byte> indexedElementConsumer) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            Byte value = values[i];
            indexedElementConsumer.accept(i, value);
        }
    }

    public static void forEach(char[] values, BiConsumer<Integer, Character> indexedElementConsumer) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            Character value = Character.valueOf(values[i]);
            indexedElementConsumer.accept(i, value);
        }
    }

    public static void forEach(short[] values, BiConsumer<Integer, Short> indexedElementConsumer) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            Short value = values[i];
            indexedElementConsumer.accept(i, value);
        }
    }

    public static void forEach(int[] values, BiConsumer<Integer, Integer> indexedElementConsumer) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            Integer value = values[i];
            indexedElementConsumer.accept(i, value);
        }
    }

    public static void forEach(long[] values, BiConsumer<Integer, Long> indexedElementConsumer) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            Long value = values[i];
            indexedElementConsumer.accept(i, value);
        }
    }

    public static void forEach(float[] values, BiConsumer<Integer, Float> indexedElementConsumer) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            Float value = Float.valueOf(values[i]);
            indexedElementConsumer.accept(i, value);
        }
    }

    public static void forEach(double[] values, BiConsumer<Integer, Double> indexedElementConsumer) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            Double value = values[i];
            indexedElementConsumer.accept(i, value);
        }
    }

    public static <T> void forEach(T[] values, BiConsumer<Integer, T> indexedElementConsumer) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            T value = values[i];
            indexedElementConsumer.accept(i, (Integer)value);
        }
    }

    public static boolean contains(boolean[] values, boolean value) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            if (values[i] != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(byte[] values, byte value) {
        return Arrays.binarySearch(values, value) > -1;
    }

    public static boolean contains(char[] values, char value) {
        return Arrays.binarySearch(values, value) > -1;
    }

    public static boolean contains(short[] values, short value) {
        return Arrays.binarySearch(values, value) > -1;
    }

    public static boolean contains(int[] values, int value) {
        return Arrays.binarySearch(values, value) > -1;
    }

    public static boolean contains(long[] values, long value) {
        return Arrays.binarySearch(values, value) > -1;
    }

    public static boolean contains(float[] values, float value) {
        return Arrays.binarySearch(values, value) > -1;
    }

    public static boolean contains(double[] values, double value) {
        return Arrays.binarySearch(values, value) > -1;
    }

    public static boolean contains(Object[] values, Object value) {
        int length = ArrayUtils.length(values);
        for (int i = 0; i < length; ++i) {
            if (!Objects.equals(values[i], value)) continue;
            return true;
        }
        return false;
    }

    public static <T> String arrayToString(T[] array) {
        return Arrays.toString(array);
    }

    public static <T> T[] reverse(T[] a) {
        int limit = a.length / 2;
        int i = 0;
        int j = a.length - 1;
        while (i < limit) {
            T t = a[i];
            a[i] = a[j];
            a[j] = t;
            ++i;
            --j;
        }
        return a;
    }

    public static <T> T[] toArrayReversed(Collection<?> coll, T[] array) {
        T[] newArray = ArrayUtils.reverse(coll.toArray(Arrays.copyOfRange(array, 0, 0)));
        if (newArray.length > array.length) {
            return newArray;
        }
        System.arraycopy(newArray, 0, array, 0, newArray.length);
        if (array.length > newArray.length) {
            array[newArray.length] = null;
        }
        return array;
    }

    private ArrayUtils() {
    }
}

