/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.SetUtils;
import io.microsphere.constants.SeparatorConstants;
import io.microsphere.management.JmxUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.Utils;
import java.lang.management.RuntimeMXBean;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Set;

public abstract class ClassPathUtils
implements Utils {
    protected static final RuntimeMXBean runtimeMXBean = JmxUtils.getRuntimeMXBean();
    private static final Set<String> bootstrapClassPaths = ClassPathUtils.initBootstrapClassPaths();
    private static final Set<String> classPaths = ClassPathUtils.initClassPaths();

    private static Set<String> initBootstrapClassPaths() {
        if (runtimeMXBean.isBootClassPathSupported()) {
            return ClassPathUtils.resolveClassPaths(runtimeMXBean.getBootClassPath());
        }
        return Collections.emptySet();
    }

    private static Set<String> initClassPaths() {
        return ClassPathUtils.resolveClassPaths(runtimeMXBean.getClassPath());
    }

    private static Set<String> resolveClassPaths(String classPath) {
        String[] classPathsArray = StringUtils.split(classPath, SeparatorConstants.PATH_SEPARATOR);
        return SetUtils.ofSet(classPathsArray);
    }

    @Nonnull
    public static Set<String> getBootstrapClassPaths() {
        return bootstrapClassPaths;
    }

    @Nonnull
    public static Set<String> getClassPaths() {
        return classPaths;
    }

    @Nullable
    public static URL getRuntimeClassLocation(String className) {
        ClassLoader classLoader = ClassLoaderUtils.getDefaultClassLoader();
        if (ClassLoaderUtils.isLoadedClass(classLoader, className)) {
            return ClassPathUtils.getRuntimeClassLocation(ClassLoaderUtils.resolveClass(className, classLoader));
        }
        return null;
    }

    @Nullable
    public static URL getRuntimeClassLocation(Class<?> type) {
        ClassLoader classLoader = type.getClassLoader();
        URL location = null;
        if (classLoader != null) {
            try {
                ProtectionDomain protectionDomain = type.getProtectionDomain();
                CodeSource codeSource = protectionDomain.getCodeSource();
                location = codeSource == null ? null : codeSource.getLocation();
            }
            catch (SecurityException securityException) {}
        } else if (!(type.isPrimitive() || type.isArray() || type.isSynthetic())) {
            location = ClassLoaderUtils.getClassResource(ClassLoader.getSystemClassLoader(), type.getName());
        }
        return location;
    }

    private ClassPathUtils() {
    }
}

