/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.MapUtils;
import io.microsphere.collection.SetUtils;
import io.microsphere.filter.ClassFileJarEntryFilter;
import io.microsphere.filter.JarEntryFilter;
import io.microsphere.io.FileUtils;
import io.microsphere.io.filter.FileExtensionFilter;
import io.microsphere.io.scanner.SimpleFileScanner;
import io.microsphere.io.scanner.SimpleJarEntryScanner;
import io.microsphere.lang.function.Predicates;
import io.microsphere.lang.function.ThrowableSupplier;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.net.URLUtils;
import io.microsphere.reflect.ConstructorUtils;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.TypeFinder;
import io.microsphere.util.Utils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class ClassUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(ClassUtils.class);
    public static final String ARRAY_SUFFIX = "[]";
    public static final Set<Class<?>> SIMPLE_TYPES = SetUtils.ofSet(Void.class, Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, BigDecimal.class, BigInteger.class, Date.class, Object.class);
    public static final Set<Class<?>> PRIMITIVE_TYPES = SetUtils.ofSet(Void.TYPE, Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    public static final Set<Class<?>> PRIMITIVE_ARRAY_TYPES = SetUtils.ofSet(boolean[].class, char[].class, byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class);
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_NAME_MAP;
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_TYPE_MAP;
    private static final Map<Class<?>, Class<?>> WRAPPER_PRIMITIVE_TYPE_MAP;
    static final Map<Class<?>, Boolean> concreteClassCache;
    private static final FileExtensionFilter JAR_FILE_EXTENSION_FILTER;

    public static boolean isArray(Class<?> type) {
        return type != null && type.isArray();
    }

    public static boolean isConcreteClass(Class<?> type) {
        if (type == null) {
            return false;
        }
        if (concreteClassCache.containsKey(type)) {
            return true;
        }
        if (ClassUtils.isGeneralClass(type, Boolean.FALSE)) {
            concreteClassCache.put(type, Boolean.TRUE);
            return true;
        }
        return false;
    }

    public static boolean isAbstractClass(Class<?> type) {
        return ClassUtils.isGeneralClass(type, Boolean.TRUE);
    }

    public static boolean isGeneralClass(Class<?> type) {
        return ClassUtils.isGeneralClass(type, Boolean.FALSE);
    }

    protected static boolean isGeneralClass(Class<?> type, Boolean isAbstract) {
        if (type == null) {
            return false;
        }
        int mod = type.getModifiers();
        if (ClassUtils.isAnnotation(mod) || ClassUtils.isEnum(mod) || Modifier.isInterface(mod) || ClassUtils.isSynthetic(mod) || ClassUtils.isPrimitive(type) || ClassUtils.isArray(type)) {
            return false;
        }
        if (isAbstract != null) {
            return Modifier.isAbstract(mod) == isAbstract;
        }
        return true;
    }

    public static boolean isTopLevelClass(Class<?> type) {
        return type != null && !type.isLocalClass() && !type.isMemberClass();
    }

    public static boolean isPrimitive(Class<?> type) {
        return PRIMITIVE_TYPES.contains(type);
    }

    public static boolean isFinal(Class<?> type) {
        return type != null && Modifier.isFinal(type.getModifiers());
    }

    public static boolean isSimpleType(Class<?> type) {
        return SIMPLE_TYPES.contains(type);
    }

    public static Class<?> resolvePrimitiveType(Class<?> type) {
        if (ClassUtils.isPrimitive(type)) {
            return type;
        }
        return PRIMITIVE_WRAPPER_TYPE_MAP.get(type);
    }

    public static Class<?> resolveWrapperType(Class<?> primitiveType) {
        if (PRIMITIVE_WRAPPER_TYPE_MAP.containsKey(primitiveType)) {
            return primitiveType;
        }
        return WRAPPER_PRIMITIVE_TYPE_MAP.get(primitiveType);
    }

    public static boolean isWrapperType(Class<?> type) {
        return PRIMITIVE_WRAPPER_TYPE_MAP.containsKey(type);
    }

    public static boolean arrayTypeEquals(Class<?> oneArrayType, Class<?> anotherArrayType) {
        if (!ClassUtils.isArray(oneArrayType) || !ClassUtils.isArray(anotherArrayType)) {
            return false;
        }
        Class<?> oneComponentType = oneArrayType.getComponentType();
        Class<?> anotherComponentType = anotherArrayType.getComponentType();
        if (ClassUtils.isArray(oneComponentType) && ClassUtils.isArray(anotherComponentType)) {
            return ClassUtils.arrayTypeEquals(oneComponentType, anotherComponentType);
        }
        return Objects.equals(oneComponentType, anotherComponentType);
    }

    public static Class<?> resolvePrimitiveClassName(String name) {
        Class<?> result = null;
        if (name != null && name.length() <= 8) {
            result = PRIMITIVE_TYPE_NAME_MAP.get(name);
        }
        return result;
    }

    @Nullable
    public static String resolvePackageName(Class<?> targetClass) {
        return ClassUtils.isPrimitive(targetClass) ? null : ClassUtils.resolvePackageName(ClassUtils.getTypeName(targetClass));
    }

    @Nullable
    public static String resolvePackageName(String className) {
        return StringUtils.substringBeforeLast(className, ".");
    }

    @Nonnull
    public static Set<String> findClassNamesInClassPath(String classPath, boolean recursive) {
        String protocol = URLUtils.resolveProtocol(classPath);
        String resolvedClassPath = "file".equals(protocol) ? StringUtils.substringBetween(classPath, protocol + ':', "!/") : classPath;
        File classesFileHolder = new File(resolvedClassPath);
        return ClassUtils.findClassNamesInClassPath(classesFileHolder, recursive);
    }

    public static Set<String> findClassNamesInClassPath(File classPath, boolean recursive) {
        if (classPath == null || !classPath.exists()) {
            return Collections.emptySet();
        }
        Set<String> classNames = Collections.emptySet();
        if (classPath.isDirectory()) {
            classNames = ClassUtils.findClassNamesInDirectory(classPath, recursive);
        } else if (classPath.isFile() && JAR_FILE_EXTENSION_FILTER.accept(classPath)) {
            classNames = ClassUtils.findClassNamesInJarFile(classPath, recursive);
        }
        if (CollectionUtils.isEmpty(classNames) && logger.isTraceEnabled()) {
            logger.trace("No Class was found in the classPath : '{}' , recursive : {}", classPath, recursive);
        }
        return classNames;
    }

    public static Set<String> findClassNamesInDirectory(File classesDirectory, boolean recursive) {
        if (classesDirectory == null || !classesDirectory.exists()) {
            return Collections.emptySet();
        }
        Set<File> classFiles = SimpleFileScanner.INSTANCE.scan(classesDirectory, recursive, FileExtensionFilter.of("class"));
        if (CollectionUtils.isEmpty(classFiles)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> classNames = new LinkedHashSet<String>();
        for (File classFile : classFiles) {
            String className = ClassUtils.resolveClassName(classesDirectory, classFile);
            classNames.add(className);
        }
        return Collections.unmodifiableSet(classNames);
    }

    public static Set<String> findClassNamesInJarFile(File jarFile, boolean recursive) {
        Set<String> classNames;
        block6: {
            if (jarFile == null || !jarFile.exists()) {
                return Collections.emptySet();
            }
            try {
                JarFile jarFile_ = new JarFile(jarFile);
                Set<JarEntry> jarEntries = SimpleJarEntryScanner.INSTANCE.scan(jarFile_, recursive, (JarEntryFilter)ClassFileJarEntryFilter.INSTANCE);
                if (CollectionUtils.isEmpty(jarEntries)) {
                    classNames = Collections.emptySet();
                } else {
                    classNames = SetUtils.newLinkedHashSet();
                    for (JarEntry jarEntry : jarEntries) {
                        String jarEntryName = jarEntry.getName();
                        String className = ClassUtils.resolveClassName(jarEntryName);
                        if (!StringUtils.isNotBlank(className)) continue;
                        classNames.add(className);
                    }
                }
            }
            catch (Exception e) {
                classNames = Collections.emptySet();
                if (!logger.isTraceEnabled()) break block6;
                logger.trace("The class names can't be resolved by SimpleJarEntryScanner#scan(jarFile = {} , recursive = {} , jarEntryFilter = ClassFileJarEntryFilter)", jarFile, recursive, e);
            }
        }
        return classNames;
    }

    protected static String resolveClassName(File classesDirectory, File classFile) {
        String classFileRelativePath = FileUtils.resolveRelativePath(classesDirectory, classFile);
        return ClassUtils.resolveClassName(classFileRelativePath);
    }

    public static String resolveClassName(String resourceName) {
        String className = StringUtils.replace(resourceName, "/", ".");
        className = StringUtils.substringBefore(className, ".class");
        while (StringUtils.startsWith(className, ".")) {
            className = StringUtils.substringAfter(className, ".");
        }
        return className;
    }

    public static List<Class<?>> getAllSuperClasses(Class<?> type) {
        return ClassUtils.findAllSuperClasses(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    public static List<Class<?>> getAllInterfaces(Class<?> type) {
        return ClassUtils.findAllInterfaces(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    public static List<Class<?>> getAllInheritedTypes(Class<?> type) {
        return ClassUtils.getAllInheritedClasses(type);
    }

    public static List<Class<?>> getAllInheritedClasses(Class<?> type) {
        return ClassUtils.findAllInheritedClasses(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    public static List<Class<?>> getAllClasses(Class<?> type) {
        return ClassUtils.findAllClasses(type, Predicates.EMPTY_PREDICATE_ARRAY);
    }

    public static List<Class<?>> findAllSuperClasses(Class<?> type, Predicate<? super Class<?>> ... classFilters) {
        return ClassUtils.findTypes(type, false, true, true, false, classFilters);
    }

    public static List<Class<?>> findAllInterfaces(Class<?> type, Predicate<? super Class<?>> ... interfaceFilters) {
        return ClassUtils.findTypes(type, false, true, false, true, interfaceFilters);
    }

    public static List<Class<?>> findAllInheritedClasses(Class<?> type, Predicate<? super Class<?>> ... classFilters) {
        return ClassUtils.findTypes(type, false, true, true, true, classFilters);
    }

    public static List<Class<?>> findAllClasses(Class<?> type, Predicate<? super Class<?>> ... classFilters) {
        return ClassUtils.findTypes(type, true, true, true, true, classFilters);
    }

    protected static List<Class<?>> findTypes(Class<?> type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeGenericSuperclass, boolean includeGenericInterfaces, Predicate<? super Class<?>> ... typeFilters) {
        if (type == null || ClassUtils.isPrimitive(type)) {
            return Collections.emptyList();
        }
        return TypeFinder.classFinder(type, includeSelf, includeHierarchicalTypes, includeGenericSuperclass, includeGenericInterfaces).findTypes(typeFilters);
    }

    public static boolean isAssignableFrom(Class<?> superType, Class<?> targetType) {
        if (superType == null || targetType == null) {
            return false;
        }
        if (Objects.equals(superType, targetType)) {
            return true;
        }
        return superType.isAssignableFrom(targetType);
    }

    public static Class[] getTypes(Object ... values) {
        return ClassUtils.resolveTypes(values);
    }

    public static Class[] resolveTypes(Object ... values) {
        if (ArrayUtils.isEmpty(values)) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        int size = values.length;
        Class[] types = new Class[size];
        for (int i = 0; i < size; ++i) {
            Object value = values[i];
            types[i] = value == null ? null : value.getClass();
        }
        return types;
    }

    public static String getTypeName(Class<?> type) {
        if (type.isArray()) {
            try {
                Class<?> cl = type;
                int dimensions = 0;
                while (cl.isArray()) {
                    ++dimensions;
                    cl = cl.getComponentType();
                }
                String name = ClassUtils.getTypeName(cl);
                StringBuilder sb = new StringBuilder(name.length() + dimensions * 2);
                sb.append(name);
                for (int i = 0; i < dimensions; ++i) {
                    sb.append(ARRAY_SUFFIX);
                }
                return sb.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return type.getName();
    }

    public static String getSimpleName(Class<?> type) {
        boolean array = type.isArray();
        return ClassUtils.getSimpleName(type, array);
    }

    private static String getSimpleName(Class<?> type, boolean array) {
        if (array) {
            return ClassUtils.getSimpleName(type.getComponentType()) + ARRAY_SUFFIX;
        }
        String simpleName = type.getName();
        Class<?> enclosingClass = type.getEnclosingClass();
        if (enclosingClass != null) {
            int index;
            String ecName = enclosingClass.getName();
            int length = (simpleName = simpleName.substring(ecName.length())).length();
            if (length < 1 || simpleName.charAt(0) != '$') {
                throw new InternalError("Malformed class name");
            }
            for (index = 1; index < length && ClassUtils.isAsciiDigit(simpleName.charAt(index)); ++index) {
            }
            return simpleName.substring(index);
        }
        simpleName = simpleName.substring(simpleName.lastIndexOf(46) + 1);
        return simpleName;
    }

    private static boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    public static boolean isDerived(Class<?> targetType, Class<?> ... superTypes) {
        if (superTypes == null || superTypes.length == 0 || targetType == null) {
            return false;
        }
        boolean derived = false;
        for (Class<?> superType : superTypes) {
            if (!ClassUtils.isAssignableFrom(superType, targetType)) continue;
            derived = true;
            break;
        }
        return derived;
    }

    public static <T> T newInstance(Class<T> type, Object ... args) {
        int length = ArrayUtils.length(args);
        List<Constructor<?>> constructors = ConstructorUtils.findDeclaredConstructors(type, constructor -> {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (length != parameterTypes.length) {
                return false;
            }
            for (int i = 0; i < length; ++i) {
                Object arg = args[i];
                Class<?> parameterType = parameterTypes[i];
                if (ClassUtils.isPrimitive(parameterType)) {
                    parameterType = ClassUtils.resolveWrapperType(parameterType);
                }
                if (parameterType.isInstance(arg)) continue;
                return false;
            }
            return true;
        });
        if (constructors.isEmpty()) {
            String message = FormatUtils.format("No constructor[class : '{}'] matches the arguments : {}", ClassUtils.getTypeName(type), ArrayUtils.arrayToString(args));
            throw new IllegalArgumentException(message);
        }
        Constructor<?> constructor2 = constructors.get(0);
        return (T)ThrowableSupplier.execute(() -> constructor2.newInstance(args));
    }

    public static Class<?> getTopComponentType(Object array) {
        return array == null ? null : ClassUtils.getTopComponentType(array.getClass());
    }

    public static Class<?> getTopComponentType(Class<?> arrayType) {
        if (!ClassUtils.isArray(arrayType)) {
            return null;
        }
        Class<?> targetType = null;
        Class<?> componentType = arrayType.getComponentType();
        while (componentType != null) {
            targetType = componentType;
            componentType = ClassUtils.getTopComponentType(componentType);
        }
        return targetType;
    }

    public static <T> T cast(Object object, Class<T> castType) {
        if (object == null || castType == null) {
            return null;
        }
        return castType.isInstance(object) ? (T)castType.cast(object) : null;
    }

    static boolean isAnnotation(int modifiers) {
        return io.microsphere.reflect.Modifier.ANNOTATION.matches(modifiers);
    }

    static boolean isEnum(int modifiers) {
        return io.microsphere.reflect.Modifier.ENUM.matches(modifiers);
    }

    static boolean isSynthetic(int modifiers) {
        return io.microsphere.reflect.Modifier.SYNTHETIC.matches(modifiers);
    }

    private ClassUtils() {
    }

    static {
        concreteClassCache = Collections.synchronizedMap(new WeakHashMap());
        JAR_FILE_EXTENSION_FILTER = FileExtensionFilter.of(".jar");
        PRIMITIVE_WRAPPER_TYPE_MAP = MapUtils.ofMap(Void.class, Void.TYPE, Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE);
        WRAPPER_PRIMITIVE_TYPE_MAP = MapUtils.ofMap(Void.TYPE, Void.class, Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class);
        Map primitiveTypeNameMap = MapUtils.newFixedHashMap(17);
        PRIMITIVE_TYPES.forEach(type -> primitiveTypeNameMap.put(type.getName(), type));
        PRIMITIVE_ARRAY_TYPES.forEach(type -> primitiveTypeNameMap.put(type.getName(), type));
        PRIMITIVE_TYPE_NAME_MAP = Collections.unmodifiableMap(primitiveTypeNameMap);
    }
}

