/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.text.FormatUtils;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Configurer<T> {
    private static final Logger logger = LoggerFactory.getLogger(Configurer.class);
    private static final String UNNAMED = "UNNAMED";
    private final String name;
    private T value;
    private StringBuilder logBuilder = new StringBuilder();

    protected Configurer(String name) {
        this.name = name;
    }

    protected Configurer(Supplier<T> valueSupplier) {
        this(valueSupplier.get());
    }

    protected Configurer(T value) {
        this(UNNAMED, value);
    }

    protected Configurer(String name, Supplier<T> valueSupplier) {
        this(name, valueSupplier.get());
    }

    protected Configurer(String name, T value) {
        this.name = name;
        this.value = value;
        this.logBuilder = new StringBuilder();
        this.logBuilder.append(FormatUtils.format("'{}' the config value is initialized \uff1a'{}'", name, value));
    }

    public <T> Configurer<T> value(T value) {
        return new Configurer<T>(this.name, value);
    }

    public <T> Configurer<T> value(Supplier<T> valueSupplier) {
        return new Configurer<Supplier<T>>(this.name, valueSupplier);
    }

    public Configurer<T> compare(Supplier<T> comparedValueSupplier) {
        return this.compare(comparedValueSupplier.get());
    }

    public Configurer<T> compare(T comparedValue) {
        if (this.value != null && Objects.equals(this.value, comparedValue)) {
            this.logBuilder.append(FormatUtils.format(", the config value is not changed[current\uff1a'{}'\uff0ccompared\uff1a'{}']", this.value, comparedValue));
            this.value = null;
        }
        return this;
    }

    public Configurer<T> on(Predicate<? super T> predicate) {
        if (this.value != null && !predicate.test(this.value)) {
            this.logBuilder.append(FormatUtils.format(", the config value[current\uff1a'{}'] does not match", this.value));
            this.value = null;
        }
        return this;
    }

    public <R> Configurer<R> as(Function<T, R> function) {
        T result;
        if (this.value != null) {
            result = (T)function.apply(this.value);
            this.logBuilder.append(FormatUtils.format(", the config value is converted[current\uff1a'{}'\uff0ctarget\uff1a'{}']", this.value, result));
        } else {
            result = null;
        }
        if (result == null) {
            this.value = null;
            return this;
        }
        Configurer<Object> configurer = new Configurer<Object>(this.name, result);
        configurer.logBuilder = this.logBuilder;
        return configurer;
    }

    public void apply(Consumer<T> valueConsumer) {
        if (this.value != null) {
            valueConsumer.accept(this.value);
            this.logBuilder.append(", the config value is applied");
        } else {
            this.logBuilder.append(", the config value is discarded");
        }
        logger.info(this.logBuilder.toString());
    }

    public static <T> Configurer<T> configure(String name) {
        return new Configurer<T>(name);
    }

    public static <T> Configurer<T> configure(String name, T value) {
        return new Configurer<T>(name, value);
    }

    public static <T> Configurer<T> configure(String name, Supplier<T> valueSupplier) {
        return new Configurer<Supplier<T>>(name, valueSupplier);
    }

    public static <T> Configurer<T> configure(T value) {
        return new Configurer<T>(value);
    }

    public static <T> Configurer<T> configure(Supplier<T> valueSupplier) {
        return new Configurer<Supplier<T>>(valueSupplier);
    }
}

