/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Functional<V> {
    private static final String UNNAMED = "UNNAMED";
    private final String name;
    private final V value;
    private Boolean matched = null;

    protected Functional(String name, V value) {
        this.name = name;
        this.value = value;
    }

    public Functional<V> on(Predicate<? super V> predicate) {
        if (this.isSkip()) {
            return this;
        }
        V value = this.value;
        if (value != null) {
            this.matched = predicate.test(value);
        }
        return this;
    }

    public <R> Functional<R> as(Function<V, R> function) {
        if (this.isSkip()) {
            return this;
        }
        R result = function.apply(this.value);
        return new Functional<R>(this.name, result);
    }

    public void apply(Consumer<V> valueConsumer) {
        if (this.isSkip()) {
            return;
        }
        valueConsumer.accept(this.value);
    }

    private boolean isSkip() {
        return Boolean.FALSE.equals(this.matched);
    }

    public String toString() {
        return "Functional{name='" + this.name + '\'' + ", value=" + this.value + ", matched=" + this.matched + '}';
    }

    public static <V> Functional<V> value(Supplier<V> valueSupplier) {
        return Functional.value(valueSupplier.get());
    }

    public static <V> Functional<V> value(V value) {
        return Functional.of(UNNAMED, value);
    }

    public static <V> Functional<V> of(String name, Supplier<V> valueSupplier) {
        return Functional.of(name, valueSupplier.get());
    }

    public static <V> Functional<V> of(String name, V value) {
        return new Functional<V>(name, value);
    }
}

