/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.io.IOUtils;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.PropertyResourceBundleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PropertyResourceBundleControl
extends ResourceBundle.Control {
    public static final String SUFFIX = "properties";
    private static final ConcurrentMap<String, ResourceBundle.Control> encodingControlMap = new ConcurrentHashMap<String, ResourceBundle.Control>();
    public static final PropertyResourceBundleControl DEFAULT_CONTROL = new PropertyResourceBundleControl();
    private final String encoding;

    protected PropertyResourceBundleControl() throws UnsupportedCharsetException {
        this(PropertyResourceBundleUtils.DEFAULT_ENCODING);
    }

    protected PropertyResourceBundleControl(String encoding) throws UnsupportedCharsetException {
        Charset.forName(encoding);
        this.encoding = encoding;
    }

    @Override
    public final List<String> getFormats(String baseName) {
        if (baseName == null) {
            throw new NullPointerException();
        }
        return FORMAT_PROPERTIES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader classLoader, boolean reload) throws IOException {
        String bundleName = super.toBundleName(baseName, locale);
        String resourceName = super.toResourceName(bundleName, SUFFIX);
        InputStream stream = null;
        InputStreamReader reader = null;
        PropertyResourceBundle bundle = null;
        try {
            stream = AccessController.doPrivileged(() -> {
                InputStream is = null;
                if (reload) {
                    URLConnection connection;
                    URL url = classLoader.getResource(resourceName);
                    if (url != null && (connection = url.openConnection()) != null) {
                        connection.setUseCaches(false);
                        is = connection.getInputStream();
                    }
                } else {
                    is = classLoader.getResourceAsStream(resourceName);
                }
                if (is == null) {
                    String message = FormatUtils.format("The resource[name : '{}' , baseName : '{}' , locale : '{}' , reload : {}] can't be found in the ClassLoader : {}", resourceName, baseName, locale, reload, classLoader);
                    throw new IOException(message);
                }
                return is;
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
        if (stream != null) {
            try {
                reader = new InputStreamReader(stream, this.getEncoding());
                bundle = new PropertyResourceBundle(reader);
            }
            catch (Throwable throwable) {
                IOUtils.close(stream);
                IOUtils.close(reader);
                throw throwable;
            }
            IOUtils.close(stream);
            IOUtils.close(reader);
        }
        return bundle;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static ResourceBundle.Control newControl(String encoding) throws UnsupportedCharsetException {
        return encodingControlMap.computeIfAbsent(encoding, PropertyResourceBundleControl::new);
    }

    static {
        encodingControlMap.put(DEFAULT_CONTROL.getEncoding(), DEFAULT_CONTROL);
        PropertyResourceBundleControl.newControl("UTF-8");
    }
}

