/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.QueueUtils;
import io.microsphere.lang.Prioritized;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.FieldUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ShutdownHookCallbacksThread;
import io.microsphere.util.Utils;
import java.util.Collections;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class ShutdownHookUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownHookUtils.class);
    public static final String SHUTDOWN_HOOK_CALLBACKS_CAPACITY_PROPERTY_NAME = "microsphere.shutdown-hook.callbacks-capacity";
    public static final int SHUTDOWN_HOOK_CALLBACKS_CAPACITY = Integer.getInteger("microsphere.shutdown-hook.callbacks-capacity", 512);
    public static final Predicate<? super Thread> SHUTDOWN_HOOK_CALLBACKS_THREAD_FILTER = t -> ShutdownHookCallbacksThread.class == t.getClass();
    static final PriorityBlockingQueue<Runnable> shutdownHookCallbacks = new PriorityBlockingQueue<Object>(SHUTDOWN_HOOK_CALLBACKS_CAPACITY, Prioritized.COMPARATOR);
    private static final String TARGET_CLASS_NAME = "java.lang.ApplicationShutdownHooks";
    private static final String HOOKS_FIELD_NAME = "hooks";

    public static void registerShutdownHook() {
        Set<Thread> shutdownHookThreads = ShutdownHookUtils.filterShutdownHookThreads(SHUTDOWN_HOOK_CALLBACKS_THREAD_FILTER);
        if (shutdownHookThreads.isEmpty()) {
            Runtime.getRuntime().addShutdownHook(ShutdownHookCallbacksThread.INSTANCE);
        }
    }

    @Nonnull
    public static Set<Thread> getShutdownHookThreads() {
        return ShutdownHookUtils.filterShutdownHookThreads(t -> true);
    }

    public static Set<Thread> filterShutdownHookThreads(Predicate<? super Thread> hookThreadFilter) {
        return ShutdownHookUtils.filterShutdownHookThreads(hookThreadFilter, false);
    }

    @Nonnull
    public static Set<Thread> filterShutdownHookThreads(Predicate<? super Thread> hookThreadFilter, boolean removed) {
        Map<Thread, Thread> shutdownHookThreadsMap = ShutdownHookUtils.shutdownHookThreadsMap();
        Set<Thread> shutdownHookThreads = shutdownHookThreadsMap.keySet().stream().filter(hookThreadFilter).collect(Collectors.toSet());
        if (removed) {
            shutdownHookThreads.forEach(shutdownHookThreadsMap::remove);
        }
        return Collections.unmodifiableSet(shutdownHookThreads);
    }

    public static boolean addShutdownHookCallback(@Nullable Runnable callback) {
        boolean added = false;
        if (callback != null) {
            added = shutdownHookCallbacks.add(callback);
        }
        return added;
    }

    public static boolean removeShutdownHookCallback(@Nullable Runnable callback) {
        boolean removed = false;
        if (callback != null) {
            removed = shutdownHookCallbacks.remove(callback);
        }
        return removed;
    }

    @Nonnull
    public static Queue<Runnable> getShutdownHookCallbacks() {
        return QueueUtils.unmodifiableQueue(shutdownHookCallbacks);
    }

    static void clearShutdownHookCallbacks() {
        shutdownHookCallbacks.clear();
    }

    private static Map<Thread, Thread> shutdownHookThreadsMap() {
        Class<?> applicationShutdownHooksClass = ClassLoaderUtils.resolveClass(TARGET_CLASS_NAME, ClassLoader.getSystemClassLoader());
        return applicationShutdownHooksClass == null ? Collections.emptyMap() : (Map)FieldUtils.getStaticFieldValue(applicationShutdownHooksClass, HOOKS_FIELD_NAME);
    }

    private ShutdownHookUtils() {
    }

    static {
        ShutdownHookUtils.registerShutdownHook();
    }
}

