/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.util.StringUtils;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;

public class StopWatch {
    private final String id;
    private final List<Task> runningTasks = new LinkedList<Task>();
    private final List<Task> completedTasks = new LinkedList<Task>();
    private long totalTimeNanos;

    public StopWatch(String id) {
        this.id = id;
    }

    public void start(String taskName) throws IllegalArgumentException, IllegalStateException {
        this.start(taskName, false);
    }

    public void start(String taskName, boolean reentrant) throws IllegalArgumentException, IllegalStateException {
        if (StringUtils.isBlank(taskName)) {
            throw new IllegalArgumentException("The 'taskName' argument must not be blank");
        }
        List<Task> runningTasks = this.runningTasks;
        Task newTask = Task.start(taskName, reentrant);
        int taskIndex = runningTasks.indexOf(newTask);
        if (taskIndex > -1) {
            Task oldTask = runningTasks.get(taskIndex);
            if (oldTask.reentrant) {
                return;
            }
            throw new IllegalStateException("StopWatch[id : '" + this.id + "']'s Task[name : '" + taskName + "' , number=" + (taskIndex + 1) + "] is already running");
        }
        runningTasks.add(newTask);
    }

    public void stop() throws IllegalStateException {
        Task currentTask = this.getCurrentTask(true);
        if (currentTask == null) {
            throw new IllegalStateException("No task is running");
        }
        currentTask.stop();
        this.totalTimeNanos += currentTask.elapsedNanos;
        this.completedTasks.add(currentTask);
    }

    public Task getCurrentTask() {
        return this.getCurrentTask(false);
    }

    protected Task getCurrentTask(boolean removed) {
        List<Task> runningTasks = this.runningTasks;
        int size = runningTasks.size();
        if (size == 0) {
            return null;
        }
        int currentTaskIndex = size - 1;
        return removed ? runningTasks.remove(currentTaskIndex) : runningTasks.get(currentTaskIndex);
    }

    public String getId() {
        return this.id;
    }

    public List<Task> getRunningTasks() {
        return Collections.unmodifiableList(this.runningTasks);
    }

    public List<Task> getCompletedTasks() {
        return Collections.unmodifiableList(this.completedTasks);
    }

    public long getTotalTimeNanos() {
        return this.totalTimeNanos;
    }

    public long getTotalTime(TimeUnit timeUnit) {
        return TimeUnit.NANOSECONDS.convert(this.totalTimeNanos, timeUnit);
    }

    public String toString() {
        return new StringJoiner(", ", StopWatch.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("running tasks=" + this.runningTasks).add("completed tasks=" + this.completedTasks).add("totalTime(ns)=" + this.totalTimeNanos).toString();
    }

    public static class Task {
        private final String taskName;
        private final boolean reentrant;
        private final long startTimeNanos;
        private long elapsedNanos;

        private Task(String taskName, boolean reentrant) {
            this.taskName = taskName;
            this.reentrant = reentrant;
            this.startTimeNanos = System.nanoTime();
        }

        public static Task start(String taskName) {
            return Task.start(taskName, false);
        }

        public static Task start(String taskName, boolean reentrant) {
            return new Task(taskName, reentrant);
        }

        public void stop() {
            this.elapsedNanos = System.nanoTime() - this.startTimeNanos;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public boolean isReentrant() {
            return this.reentrant;
        }

        public long getStartTimeNanos() {
            return this.startTimeNanos;
        }

        public long getElapsedNanos() {
            return this.elapsedNanos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Task task = (Task)o;
            return Objects.equals(this.taskName, task.taskName);
        }

        public int hashCode() {
            return Objects.hash(this.taskName);
        }

        public String toString() {
            return new StringJoiner(", ", "Task[", "]").add("name='" + this.taskName + "'").add("elapsed(ns)=" + this.elapsedNanos).toString();
        }
    }
}

