/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.collection.ListUtils;
import io.microsphere.lang.function.Predicates;
import io.microsphere.lang.function.Streams;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Assert;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class TypeFinder<T> {
    private final T type;
    private final boolean includeSelf;
    private final boolean includeHierarchicalTypes;
    private final boolean includeSuperclass;
    private final boolean includeInterfaces;
    private final Function<T, ? super T> getSuperClassFunction;
    private final Function<T, ? super T[]> getInterfacesFunction;
    static final Function<Class, Class> classGetSuperClassFunction = Class::getSuperclass;
    static final Function<Class, Class[]> classGetInterfacesFunction = Class::getInterfaces;
    static final Function<Type, Type> genericTypeGetSuperClassFunction = type -> {
        Class<?> klass = TypeUtils.asClass(type);
        return klass == null ? null : klass.getGenericSuperclass();
    };
    static final Function<Type, Type[]> genericTypeGetInterfacesFunction = type -> {
        Class<?> klass = TypeUtils.asClass(type);
        return klass == null ? null : klass.getGenericInterfaces();
    };

    public TypeFinder(T type, Function<T, T> getSuperClassFunction, Function<T, T[]> getInterfacesFunction, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeSuperclass, boolean includeInterfaces) {
        Assert.assertNotNull(type, () -> "The 'type' must not be null");
        Assert.assertNotNull(getSuperClassFunction, () -> "The 'getSuperClassFunction' must not be null");
        Assert.assertNotNull(getInterfacesFunction, () -> "The 'getInterfacesFunction' must not be null");
        this.type = type;
        this.getSuperClassFunction = getSuperClassFunction;
        this.getInterfacesFunction = getInterfacesFunction;
        this.includeSelf = includeSelf;
        this.includeHierarchicalTypes = includeHierarchicalTypes;
        this.includeSuperclass = includeSuperclass;
        this.includeInterfaces = includeInterfaces;
    }

    public List<T> getTypes() {
        return this.findTypes(Predicates.EMPTY_PREDICATE_ARRAY);
    }

    public List<T> findTypes(Predicate<? super T> ... typeFilters) {
        List<T> types = this.doFindTypes(typeFilters);
        return types.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(types);
    }

    protected List<T> doFindTypes(Predicate<? super T>[] typeFilters) {
        List<Object> allTypes = ListUtils.newLinkedList();
        if (this.includeSelf) {
            allTypes.add(this.type);
        }
        this.addSuperTypes(allTypes, this.type, this.includeHierarchicalTypes, this.includeSuperclass, this.includeInterfaces);
        if (ArrayUtils.isNotEmpty(typeFilters)) {
            allTypes = Streams.filterList(allTypes, Predicates.and(typeFilters));
        }
        return allTypes;
    }

    protected List<T> getSuperTypes(T type, boolean includeSuperclass, boolean includedGenericInterfaces) {
        boolean hasSuperclass;
        Object superclass = includeSuperclass && type != null ? (Object)this.getSuperClass(type) : null;
        boolean bl = hasSuperclass = superclass != null;
        if (!hasSuperclass && !includedGenericInterfaces) {
            return Collections.emptyList();
        }
        Object[] interfaceTypes = includedGenericInterfaces ? this.getInterfaces(type) : (Object[])ArrayUtils.EMPTY_TYPE_ARRAY;
        int interfaceTypesLength = interfaceTypes.length;
        int size = interfaceTypesLength + (hasSuperclass ? 1 : 0);
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<Object> types = ListUtils.newArrayList(size);
        if (hasSuperclass && !types.contains(superclass)) {
            types.add(superclass);
        }
        for (int i = 0; i < interfaceTypesLength; ++i) {
            Object interfaceType = interfaceTypes[i];
            if (types.contains(interfaceType)) continue;
            types.add(interfaceType);
        }
        return types;
    }

    protected T getSuperClass(T type) {
        return this.getSuperClassFunction.apply(type);
    }

    protected T[] getInterfaces(T type) {
        return this.getInterfacesFunction.apply(type);
    }

    protected void addSuperTypes(List<T> allTypes, T type, boolean includeHierarchicalTypes, boolean includeSuperclass, boolean includeInterfaces) {
        if (TypeUtils.isObjectType(type)) {
            return;
        }
        List<T> superTypes = this.getSuperTypes(type, includeSuperclass, includeInterfaces);
        int superTypesSize = superTypes.size();
        if (!includeSuperclass && includeHierarchicalTypes) {
            List<T> parentTypes = this.getSuperTypes(type, true, false);
            int size = parentTypes.size();
            for (int i = 0; i < size; ++i) {
                this.addSuperTypes(allTypes, parentTypes.get(i), true, false, includeInterfaces);
            }
        }
        if (superTypesSize < 1) {
            return;
        }
        for (int i = 0; i < superTypesSize; ++i) {
            T superType = superTypes.get(i);
            if (!allTypes.contains(superType)) {
                allTypes.add(superType);
            }
            if (!includeHierarchicalTypes) continue;
            this.addSuperTypes(allTypes, superType, true, includeSuperclass, includeInterfaces);
        }
    }

    public static TypeFinder<Class<?>> classFinder(Class type, Include ... includes) {
        Assert.assertNotEmpty((Object[])includes, () -> "The 'includes' must not be empty");
        Assert.assertNoNullElements((Object[])includes, () -> "The 'includes' must not contain null element");
        return TypeFinder.classFinder(type, ArrayUtils.contains((Object[])includes, (Object)Include.SELF), ArrayUtils.contains((Object[])includes, (Object)Include.HIERARCHICAL), ArrayUtils.contains((Object[])includes, (Object)Include.SUPER_CLASS), ArrayUtils.contains((Object[])includes, (Object)Include.INTERFACES));
    }

    public static TypeFinder<Class<?>> classFinder(Class type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeSuperclass, boolean includeInterfaces) {
        return new TypeFinder(type, classGetSuperClassFunction, classGetInterfacesFunction, includeSelf, includeHierarchicalTypes, includeSuperclass, includeInterfaces);
    }

    public static TypeFinder<Type> genericTypeFinder(Type type, Include ... includes) {
        Assert.assertNotEmpty((Object[])includes, () -> "The 'includes' must not be empty");
        Assert.assertNoNullElements((Object[])includes, () -> "The 'includes' must not contain null element");
        return TypeFinder.genericTypeFinder(type, ArrayUtils.contains((Object[])includes, (Object)Include.SELF), ArrayUtils.contains((Object[])includes, (Object)Include.HIERARCHICAL), ArrayUtils.contains((Object[])includes, (Object)Include.SUPER_CLASS), ArrayUtils.contains((Object[])includes, (Object)Include.INTERFACES));
    }

    public static TypeFinder<Type> genericTypeFinder(Type type, boolean includeSelf, boolean includeHierarchicalTypes, boolean includeSuperclass, boolean includeInterfaces) {
        return new TypeFinder<Type>(type, genericTypeGetSuperClassFunction, genericTypeGetInterfacesFunction, includeSelf, includeHierarchicalTypes, includeSuperclass, includeInterfaces);
    }

    public static enum Include {
        SELF,
        HIERARCHICAL,
        SUPER_CLASS,
        INTERFACES;

    }
}

