/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.annotation.Nonnull;
import io.microsphere.lang.ClassDataRepository;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.Assert;
import java.io.Serializable;
import java.net.URL;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.function.BiPredicate;

public class Version
implements Comparable<Version>,
Serializable {
    private static final long serialVersionUID = -6434504483466016691L;
    private final int major;
    private final int minor;
    private final int patch;

    public Version(int major) {
        this(major, 0);
    }

    public Version(int major, int minor) {
        this(major, minor, 0);
    }

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean gt(Version that) {
        return this.isGreaterThan(that);
    }

    public boolean isGreaterThan(Version that) {
        return Operator.GT.test(this, that);
    }

    public boolean ge(Version that) {
        return this.isGreaterOrEqual(that);
    }

    public boolean isGreaterOrEqual(Version that) {
        return Operator.GE.test(this, that);
    }

    public boolean lt(Version that) {
        return this.isLessThan(that);
    }

    public boolean isLessThan(Version that) {
        return Operator.LT.test(this, that);
    }

    public boolean le(Version that) {
        return this.isLessOrEqual(that);
    }

    public boolean isLessOrEqual(Version that) {
        return Operator.LE.test(this, that);
    }

    public boolean eq(Version that) {
        return this.equals(that);
    }

    public boolean equals(Version that) {
        return Operator.EQ.test(this, that);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.equals(version);
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    @Override
    public int compareTo(Version that) {
        int result = Integer.compare(this.major, that.major);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.minor, that.minor);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.patch, that.patch);
        return result;
    }

    public String toString() {
        return "Version{major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + '}';
    }

    public static Version of(int major) {
        return Version.ofVersion(major);
    }

    public static Version of(int major, int minor) {
        return Version.ofVersion(major, minor);
    }

    public static Version of(int major, int minor, int patch) {
        return Version.ofVersion(major, minor, patch);
    }

    public static Version of(String version) {
        return Version.ofVersion(version);
    }

    public static Version ofVersion(int major) {
        return new Version(major);
    }

    public static Version ofVersion(int major, int minor) {
        return new Version(major, minor);
    }

    public static Version ofVersion(int major, int minor, int patch) {
        return new Version(major, minor, patch);
    }

    public static Version ofVersion(String version) {
        Assert.assertNotNull((Object)version, () -> "The 'version' argument must not be null!");
        Assert.assertNotBlank(version, () -> "The 'version' argument must not be blank!");
        StringTokenizer st = new StringTokenizer(version.trim(), ".");
        int major = Version.getValue(st);
        int minor = Version.getValue(st);
        int patch = Version.getValue(st);
        return Version.of(major, minor, patch);
    }

    @Nonnull
    public static Version getVersion(Class<?> targetClass) throws IllegalArgumentException {
        Package targetPackage = targetClass.getPackage();
        String version = targetPackage.getImplementationVersion();
        if (version == null) {
            ClassDataRepository repository = ClassDataRepository.INSTANCE;
            URL classResource = repository.getCodeSourceLocation(targetClass);
            String errorMessage = FormatUtils.format("The 'Implementation-Version' manifest attribute can't be fetched from the jar file[class resource : '{}'] by the target class[name :'{}']", classResource, targetClass.getName());
            throw new IllegalArgumentException(errorMessage);
        }
        return Version.of(version);
    }

    static int getValue(StringTokenizer st) {
        if (st.hasMoreTokens()) {
            return Version.getValue(st.nextToken());
        }
        return 0;
    }

    static int getValue(String part) {
        int value;
        try {
            value = Integer.parseInt(part.trim());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The 'version' argument contains the non-number part : " + part, e);
        }
        return value;
    }

    public static enum Operator implements BiPredicate<Version, Version>
    {
        EQ("="){

            @Override
            public boolean test(Version v1, Version v2) {
                if (v1 == v2) {
                    return true;
                }
                if (v2 == null) {
                    return false;
                }
                if (v1.major != v2.major) {
                    return false;
                }
                if (v1.minor != v2.minor) {
                    return false;
                }
                return v1.patch == v2.patch;
            }
        }
        ,
        LT("<"){

            @Override
            public boolean test(Version v1, Version v2) {
                if (v1 == v2) {
                    return false;
                }
                if (v2 == null) {
                    return false;
                }
                return v1.compareTo(v2) < 0;
            }
        }
        ,
        LE("<="){

            @Override
            public boolean test(Version v1, Version v2) {
                if (v1 == v2) {
                    return true;
                }
                if (v2 == null) {
                    return false;
                }
                return v1.compareTo(v2) <= 0;
            }
        }
        ,
        GT(">"){

            @Override
            public boolean test(Version v1, Version v2) {
                if (v1 == v2) {
                    return false;
                }
                if (v2 == null) {
                    return false;
                }
                return v1.compareTo(v2) > 0;
            }
        }
        ,
        GE(">="){

            @Override
            public boolean test(Version v1, Version v2) {
                if (v1 == v2) {
                    return true;
                }
                if (v2 == null) {
                    return false;
                }
                return v1.compareTo(v2) >= 0;
            }
        };

        private final String symbol;

        private Operator(String symbol) {
            this.symbol = symbol;
        }

        public static Operator of(String symbol) {
            Operator[] operators;
            for (Operator operator : operators = Operator.values()) {
                if (!Objects.equals(symbol, operator.symbol)) continue;
                return operator;
            }
            StringBuilder messageBuilder = new StringBuilder("The Operator can't be parsed by the symbol : ").append('\'').append(symbol).append('\'').append(", only supports : ");
            for (int i = 0; i < operators.length; ++i) {
                Operator operator = operators[i];
                messageBuilder.append('\'').append(operator.symbol).append('\'');
                if (i >= operators.length - 1) continue;
                messageBuilder.append(',').append(' ');
            }
            throw new IllegalArgumentException(messageBuilder.toString());
        }
    }
}

