/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.util;

import io.microsphere.util.SystemUtils;
import io.microsphere.util.Utils;
import io.microsphere.util.Version;
import javax.lang.model.SourceVersion;

public abstract class VersionUtils
implements Utils {
    public static final SourceVersion LATEST_JAVA_VERSION = SourceVersion.latest();
    public static final Version CURRENT_JAVA_VERSION = Version.ofVersion(VersionUtils.currentJavaMajorVersion());
    public static final Version JAVA_VERSION_8 = Version.ofVersion(8);
    public static final Version JAVA_VERSION_9 = Version.ofVersion(9);
    public static final Version JAVA_VERSION_10 = Version.ofVersion(10);
    public static final Version JAVA_VERSION_11 = Version.ofVersion(11);
    public static final Version JAVA_VERSION_12 = Version.ofVersion(12);
    public static final Version JAVA_VERSION_13 = Version.ofVersion(13);
    public static final Version JAVA_VERSION_14 = Version.ofVersion(14);
    public static final Version JAVA_VERSION_15 = Version.ofVersion(15);
    public static final Version JAVA_VERSION_16 = Version.ofVersion(16);
    public static final Version JAVA_VERSION_17 = Version.ofVersion(17);
    public static final Version JAVA_VERSION_18 = Version.ofVersion(18);
    public static final Version JAVA_VERSION_19 = Version.ofVersion(19);
    public static final Version JAVA_VERSION_20 = Version.ofVersion(20);
    public static final Version JAVA_VERSION_21 = Version.ofVersion(21);
    public static final Version JAVA_VERSION_22 = Version.ofVersion(22);
    public static final Version JAVA_VERSION_23 = Version.ofVersion(23);
    public static final Version JAVA_VERSION_24 = Version.ofVersion(24);

    public static boolean testCurrentJavaVersion(String operatorSymbol, Version comparedVersion) {
        return VersionUtils.testCurrentJavaVersion(Version.Operator.of(operatorSymbol), comparedVersion);
    }

    public static boolean testCurrentJavaVersion(Version.Operator versionOperator, Version comparedVersion) {
        return VersionUtils.testVersion(CURRENT_JAVA_VERSION, versionOperator, comparedVersion);
    }

    public static boolean testVersion(String baseVersion, String operatorSymbol, String comparedVersion) {
        if (baseVersion == null || operatorSymbol == null || comparedVersion == null) {
            return false;
        }
        return VersionUtils.testVersion(Version.ofVersion(baseVersion), Version.Operator.of(operatorSymbol), Version.ofVersion(comparedVersion));
    }

    public static boolean testVersion(Version baseVersion, Version.Operator versionOperator, Version comparedVersion) {
        if (baseVersion == null || versionOperator == null || comparedVersion == null) {
            return false;
        }
        return versionOperator.test(baseVersion, comparedVersion);
    }

    static String currentJavaMajorVersion() {
        return VersionUtils.detectJavaMajorVersion(SystemUtils.JAVA_VERSION);
    }

    static String detectJavaMajorVersion(String javaVersion) {
        int firstDotIndex = javaVersion.indexOf(46);
        if (firstDotIndex > -1) {
            String majorVersion = javaVersion.substring(0, firstDotIndex);
            if ("1".equals(majorVersion)) {
                int startIndex = firstDotIndex + 1;
                int endIndex = javaVersion.indexOf(46, startIndex);
                majorVersion = javaVersion.substring(startIndex, endIndex);
            }
            return majorVersion;
        }
        return javaVersion;
    }

    private VersionUtils() {
    }
}

