/*
 * Decompiled with CFR 0.152.
 */
package io.github.millibyte1.array64;

import io.github.millibyte1.array64.Array64Iterator;
import io.github.millibyte1.array64.FastArray64;
import it.unimi.dsi.fastutil.BigArrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\t\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u000e\u0010\u0017\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018J\r\u0010\u0019\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u0015\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/github/millibyte1/array64/FastArray64Iterator;", "E", "Lio/github/millibyte1/array64/Array64Iterator;", "array", "Lio/github/millibyte1/array64/FastArray64;", "index", "", "(Lio/github/millibyte1/array64/FastArray64;J)V", "<set-?>", "getIndex", "()J", "inner", "", "[Ljava/lang/Object;", "innerIndex", "", "outerIndex", "decreaseIndices", "", "hasNext", "", "hasPrevious", "increaseIndices", "next", "()Ljava/lang/Object;", "previous", "set", "element", "(Ljava/lang/Object;)V", "array64"})
final class FastArray64Iterator<E>
implements Array64Iterator<E> {
    private long index;
    private int outerIndex;
    private int innerIndex;
    private E[] inner;
    private final FastArray64<E> array;

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        return this.getIndex() < this.array.getSize();
    }

    @Override
    public boolean hasPrevious() {
        return this.getIndex() >= 0L;
    }

    @Override
    public E next() {
        E retval = this.inner[this.innerIndex];
        this.increaseIndices();
        return retval;
    }

    @Override
    public E previous() {
        E retval = this.inner[this.innerIndex];
        this.decreaseIndices();
        return retval;
    }

    @Override
    public void set(E element) {
        this.inner[this.innerIndex] = element;
    }

    private final void increaseIndices() {
        if (this.innerIndex == 0x7FFFFFF) {
            this.innerIndex = 0;
            int n = this.outerIndex;
            this.outerIndex = n + 1;
            this.inner = this.array.getArray()[this.outerIndex];
        } else {
            int n = this.innerIndex;
            this.innerIndex = n + 1;
        }
        long l = this.getIndex();
        this.index = l + 1L;
    }

    private final void decreaseIndices() {
        if (this.innerIndex == 0) {
            this.innerIndex = 0x7FFFFFF;
            int n = this.outerIndex;
            this.outerIndex = n + -1;
            this.inner = this.array.getArray()[this.outerIndex];
        } else {
            int n = this.innerIndex;
            this.innerIndex = n + -1;
        }
        long l = this.getIndex();
        this.index = l + -1L;
    }

    public FastArray64Iterator(@NotNull FastArray64<E> array, long index) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        this.array = array;
        this.index = index;
        this.outerIndex = BigArrays.segment((long)index);
        this.innerIndex = BigArrays.displacement((long)index);
        this.inner = this.array.getArray()[this.outerIndex];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }
}

