/*
 * Decompiled with CFR 0.152.
 */
package io.github.millibyte1.array64;

import io.github.millibyte1.array64.ByteArray64;
import io.github.millibyte1.array64.ByteArray64Iterator;
import io.github.millibyte1.array64.FastByteArray64Iterator;
import it.unimi.dsi.fastutil.BigArrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\t\u001a\u00020\u0000H\u0016J\u0013\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\t\u0010\u001b\u001a\u00020\u001cH\u0096\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0019\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0018H\u0096\u0002R$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0000X\u0081\u0004\u00a2\u0006\u0010\n\u0002\u0010\u0011\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lio/github/millibyte1/array64/FastByteArray64;", "Lio/github/millibyte1/array64/ByteArray64;", "size", "", "(J)V", "array", "(Lio/github/millibyte1/array64/FastByteArray64;)V", "", "", "copy", "", "([[BZ)V", "([BZ)V", "getArray$annotations", "()V", "getArray", "()[[B", "[[B", "getSize", "()J", "equals", "other", "", "get", "", "index", "(J)Ljava/lang/Byte;", "iterator", "Lio/github/millibyte1/array64/ByteArray64Iterator;", "set", "", "value", "Companion", "array64"})
public final class FastByteArray64
implements ByteArray64 {
    private final long size;
    @NotNull
    private final byte[][] array;
    public static final long MAX_SIZE = 288230376017494016L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public long getSize() {
        return this.size;
    }

    @PublishedApi
    public static /* synthetic */ void getArray$annotations() {
    }

    @NotNull
    public final byte[][] getArray() {
        return this.array;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FastByteArray64)) {
            return false;
        }
        if (this.getSize() != ((FastByteArray64)other).getSize()) {
            return false;
        }
        ByteArray64Iterator thisIterator = this.iterator();
        ByteArray64Iterator otherIterator = ((FastByteArray64)other).iterator();
        while (thisIterator.hasNext()) {
            if (thisIterator.nextByte() == otherIterator.nextByte()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public FastByteArray64 copy() {
        return new FastByteArray64(this);
    }

    @Override
    @NotNull
    public Byte get(long index) {
        if (index >= this.getSize() || index < 0L) {
            throw (Throwable)new NoSuchElementException();
        }
        return BigArrays.get((byte[][])this.array, (long)index);
    }

    @Override
    public void set(long index, byte value) {
        if (index >= this.getSize() || index < 0L) {
            throw (Throwable)new NoSuchElementException();
        }
        BigArrays.set((byte[][])this.array, (long)index, (byte)value);
    }

    @Override
    @NotNull
    public ByteArray64Iterator iterator(long index) {
        if (index < 0L || index >= this.getSize()) {
            throw (Throwable)new IllegalArgumentException("Invalid index provided.");
        }
        return new FastByteArray64Iterator(this, index);
    }

    @Override
    @NotNull
    public ByteArray64Iterator iterator() {
        return new FastByteArray64Iterator(this, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public FastByteArray64(long size) {
        byte[][] byArray;
        FastByteArray64 fastByteArray64;
        if (size > 288230376017494016L || size <= 0L) {
            throw (Throwable)new IllegalArgumentException("Invalid size provided.");
        }
        this.size = size;
        int fullArrays = (int)(size / (long)0x8000000);
        int innerSize = (int)(size % (long)0x8000000);
        FastByteArray64 fastByteArray642 = this;
        if (innerSize == 0) {
            byte[][] byArrayArray;
            FastByteArray64 fastByteArray643 = fastByteArray642;
            byte[][] byArrayArray2 = new byte[fullArrays][];
            int n = 0;
            while (n < fullArrays) {
                int n2 = n;
                int n3 = n++;
                byArrayArray = byArrayArray2;
                boolean bl = false;
                byte[] byArray2 = new byte[0x8000000];
                byArrayArray[n3] = byArray2;
            }
            byArrayArray = byArrayArray2;
            fastByteArray64 = fastByteArray643;
            byArray = byArrayArray;
        } else {
            byte[][] byArrayArray;
            int n = fullArrays + 1;
            FastByteArray64 fastByteArray644 = fastByteArray642;
            byte[][] byArrayArray3 = new byte[n][];
            for (int i = 0; i < n; ++i) {
                void i2;
                int bl = i;
                int n4 = i;
                byArrayArray = byArrayArray3;
                boolean bl2 = false;
                byte[] byArray3 = i2 == fullArrays ? new byte[innerSize] : new byte[0x8000000];
                byArrayArray[n4] = byArray3;
            }
            byArrayArray = byArrayArray3;
            fastByteArray64 = fastByteArray644;
            byArray = byArrayArray;
        }
        fastByteArray64.array = byArray;
    }

    public FastByteArray64(@NotNull FastByteArray64 array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this(array.array, false, 2, null);
    }

    public FastByteArray64(@NotNull byte[][] array, boolean copy) {
        byte[][] byArray;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.size = BigArrays.length((byte[][])array);
        if (copy) {
            byte[][] byArray2 = BigArrays.copy((byte[][])array);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"BigArrays.copy(array)");
        } else {
            byArray = array;
        }
        this.array = byArray;
    }

    public /* synthetic */ FastByteArray64(byte[][] byArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(byArray, bl);
    }

    public FastByteArray64(@NotNull byte[] array, boolean copy) {
        byte[][] byArray;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.size = array.length;
        FastByteArray64 fastByteArray64 = this;
        if (copy) {
            byte[][] byArray2 = BigArrays.wrap((byte[])array);
            byArray = byArray2;
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"BigArrays.wrap(array)");
        } else {
            byte[][] byArrayArray;
            int n = 1;
            FastByteArray64 fastByteArray642 = fastByteArray64;
            byte[][] byArrayArray2 = new byte[n][];
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                int n4 = n2++;
                byArrayArray = byArrayArray2;
                boolean bl = false;
                byte[] byArray3 = array;
                byArrayArray[n4] = byArray3;
            }
            byArrayArray = byArrayArray2;
            fastByteArray64 = fastByteArray642;
            byArray = byArrayArray;
        }
        fastByteArray64.array = byArray;
    }

    public /* synthetic */ FastByteArray64(byte[] byArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(byArray, bl);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tH\u0086\n\u00f8\u0001\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000b"}, d2={"Lio/github/millibyte1/array64/FastByteArray64$Companion;", "", "()V", "MAX_SIZE", "", "invoke", "Lio/github/millibyte1/array64/FastByteArray64;", "size", "init", "Lkotlin/Function1;", "", "array64"})
    public static final class Companion {
        @NotNull
        public final FastByteArray64 invoke(long size, @NotNull Function1<? super Long, Byte> init) {
            int $i$f$invoke = 0;
            Intrinsics.checkNotNullParameter(init, (String)"init");
            FastByteArray64 retval = new FastByteArray64(size);
            long index = 0L;
            for (byte[] inner : retval.getArray()) {
                for (int innerIndex = 0; innerIndex < inner.length; ++innerIndex) {
                    inner[innerIndex] = ((Number)init.invoke((Object)index)).byteValue();
                    long l = index;
                    index = l + 1L;
                }
            }
            return retval;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

