/*
 * Decompiled with CFR 0.152.
 */
package io.github.millibyte1.array64;

import io.github.millibyte1.array64.FastFloatArray64Iterator;
import io.github.millibyte1.array64.FloatArray64;
import io.github.millibyte1.array64.FloatArray64Iterator;
import it.unimi.dsi.fastutil.BigArrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\t\u001a\u00020\u0000H\u0016J\u0013\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\t\u0010\u001b\u001a\u00020\u001cH\u0096\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0019\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0018H\u0096\u0002R$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0000X\u0081\u0004\u00a2\u0006\u0010\n\u0002\u0010\u0011\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lio/github/millibyte1/array64/FastFloatArray64;", "Lio/github/millibyte1/array64/FloatArray64;", "size", "", "(J)V", "array", "(Lio/github/millibyte1/array64/FastFloatArray64;)V", "", "", "copy", "", "([[FZ)V", "([FZ)V", "getArray$annotations", "()V", "getArray", "()[[F", "[[F", "getSize", "()J", "equals", "other", "", "get", "", "index", "(J)Ljava/lang/Float;", "iterator", "Lio/github/millibyte1/array64/FloatArray64Iterator;", "set", "", "value", "Companion", "array64"})
public final class FastFloatArray64
implements FloatArray64 {
    private final long size;
    @NotNull
    private final float[][] array;
    public static final long MAX_SIZE = 288230376017494016L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public long getSize() {
        return this.size;
    }

    @PublishedApi
    public static /* synthetic */ void getArray$annotations() {
    }

    @NotNull
    public final float[][] getArray() {
        return this.array;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FastFloatArray64)) {
            return false;
        }
        if (this.getSize() != ((FastFloatArray64)other).getSize()) {
            return false;
        }
        FloatArray64Iterator thisIterator = this.iterator();
        FloatArray64Iterator otherIterator = ((FastFloatArray64)other).iterator();
        while (thisIterator.hasNext()) {
            if (thisIterator.nextFloat() == otherIterator.nextFloat()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public FastFloatArray64 copy() {
        return new FastFloatArray64(this);
    }

    @Override
    @NotNull
    public Float get(long index) {
        if (index >= this.getSize() || index < 0L) {
            throw (Throwable)new NoSuchElementException();
        }
        return Float.valueOf(BigArrays.get((float[][])this.array, (long)index));
    }

    @Override
    public void set(long index, float value) {
        if (index >= this.getSize() || index < 0L) {
            throw (Throwable)new NoSuchElementException();
        }
        BigArrays.set((float[][])this.array, (long)index, (float)value);
    }

    @Override
    @NotNull
    public FloatArray64Iterator iterator(long index) {
        if (index < 0L || index >= this.getSize()) {
            throw (Throwable)new IllegalArgumentException("Invalid index provided.");
        }
        return new FastFloatArray64Iterator(this, index);
    }

    @Override
    @NotNull
    public FloatArray64Iterator iterator() {
        return new FastFloatArray64Iterator(this, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public FastFloatArray64(long size) {
        float[][] fArray;
        FastFloatArray64 fastFloatArray64;
        if (size > 288230376017494016L || size <= 0L) {
            throw (Throwable)new IllegalArgumentException("Invalid size provided.");
        }
        this.size = size;
        int fullArrays = (int)(size / (long)0x8000000);
        int innerSize = (int)(size % (long)0x8000000);
        FastFloatArray64 fastFloatArray642 = this;
        if (innerSize == 0) {
            float[][] fArrayArray;
            FastFloatArray64 fastFloatArray643 = fastFloatArray642;
            float[][] fArrayArray2 = new float[fullArrays][];
            int n = 0;
            while (n < fullArrays) {
                int n2 = n;
                int n3 = n++;
                fArrayArray = fArrayArray2;
                boolean bl = false;
                float[] fArray2 = new float[0x8000000];
                fArrayArray[n3] = fArray2;
            }
            fArrayArray = fArrayArray2;
            fastFloatArray64 = fastFloatArray643;
            fArray = fArrayArray;
        } else {
            float[][] fArrayArray;
            int n = fullArrays + 1;
            FastFloatArray64 fastFloatArray644 = fastFloatArray642;
            float[][] fArrayArray3 = new float[n][];
            for (int i = 0; i < n; ++i) {
                void i2;
                int bl = i;
                int n4 = i;
                fArrayArray = fArrayArray3;
                boolean bl2 = false;
                float[] fArray3 = i2 == fullArrays ? new float[innerSize] : new float[0x8000000];
                fArrayArray[n4] = fArray3;
            }
            fArrayArray = fArrayArray3;
            fastFloatArray64 = fastFloatArray644;
            fArray = fArrayArray;
        }
        fastFloatArray64.array = fArray;
    }

    public FastFloatArray64(@NotNull FastFloatArray64 array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this(array.array, false, 2, null);
    }

    public FastFloatArray64(@NotNull float[][] array, boolean copy) {
        float[][] fArray;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.size = BigArrays.length((float[][])array);
        if (copy) {
            float[][] fArray2 = BigArrays.copy((float[][])array);
            fArray = fArray2;
            Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"BigArrays.copy(array)");
        } else {
            fArray = array;
        }
        this.array = fArray;
    }

    public /* synthetic */ FastFloatArray64(float[][] fArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(fArray, bl);
    }

    public FastFloatArray64(@NotNull float[] array, boolean copy) {
        float[][] fArray;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.size = array.length;
        FastFloatArray64 fastFloatArray64 = this;
        if (copy) {
            float[][] fArray2 = BigArrays.wrap((float[])array);
            fArray = fArray2;
            Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"BigArrays.wrap(array)");
        } else {
            float[][] fArrayArray;
            int n = 1;
            FastFloatArray64 fastFloatArray642 = fastFloatArray64;
            float[][] fArrayArray2 = new float[n][];
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                int n4 = n2++;
                fArrayArray = fArrayArray2;
                boolean bl = false;
                float[] fArray3 = array;
                fArrayArray[n4] = fArray3;
            }
            fArrayArray = fArrayArray2;
            fastFloatArray64 = fastFloatArray642;
            fArray = fArrayArray;
        }
        fastFloatArray64.array = fArray;
    }

    public /* synthetic */ FastFloatArray64(float[] fArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(fArray, bl);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tH\u0086\n\u00f8\u0001\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000b"}, d2={"Lio/github/millibyte1/array64/FastFloatArray64$Companion;", "", "()V", "MAX_SIZE", "", "invoke", "Lio/github/millibyte1/array64/FastFloatArray64;", "size", "init", "Lkotlin/Function1;", "", "array64"})
    public static final class Companion {
        @NotNull
        public final FastFloatArray64 invoke(long size, @NotNull Function1<? super Long, Float> init) {
            int $i$f$invoke = 0;
            Intrinsics.checkNotNullParameter(init, (String)"init");
            FastFloatArray64 retval = new FastFloatArray64(size);
            long index = 0L;
            for (float[] inner : retval.getArray()) {
                for (int innerIndex = 0; innerIndex < inner.length; ++innerIndex) {
                    inner[innerIndex] = ((Number)init.invoke((Object)index)).floatValue();
                    long l = index;
                    index = l + 1L;
                }
            }
            return retval;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

