/*
 * Decompiled with CFR 0.152.
 */
package io.github.millibyte1.array64;

import io.github.millibyte1.array64.Arrays64Kt;
import io.github.millibyte1.array64.FastIntArray64;
import io.github.millibyte1.array64.IntArray64Iterator;
import it.unimi.dsi.fastutil.BigArrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0002J\b\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lio/github/millibyte1/array64/FastIntArray64Iterator;", "Lio/github/millibyte1/array64/IntArray64Iterator;", "array", "Lio/github/millibyte1/array64/FastIntArray64;", "index", "", "(Lio/github/millibyte1/array64/FastIntArray64;J)V", "<set-?>", "getIndex", "()J", "inner", "", "innerIndex", "", "outerIndex", "decreaseIndices", "", "hasNext", "", "hasPrevious", "increaseIndices", "nextInt", "previousInt", "setInt", "element", "array64"})
final class FastIntArray64Iterator
extends IntArray64Iterator {
    private long index;
    private int outerIndex;
    private int innerIndex;
    private int[] inner;
    private final FastIntArray64 array;

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public boolean hasNext() {
        return this.getIndex() < this.array.getSize();
    }

    @Override
    public boolean hasPrevious() {
        return this.getIndex() > 0L;
    }

    public int nextInt() {
        if (!this.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        int retval = this.inner[this.innerIndex];
        this.increaseIndices();
        return retval;
    }

    @Override
    public int previousInt() {
        if (!this.hasPrevious()) {
            throw (Throwable)new NoSuchElementException();
        }
        int retval = this.inner[this.innerIndex];
        this.decreaseIndices();
        return retval;
    }

    @Override
    public void setInt(int element) {
        this.inner[this.innerIndex] = element;
    }

    private final void increaseIndices() {
        if (this.innerIndex == 0x7FFFFFF) {
            this.innerIndex = 0;
            int n = this.outerIndex;
            this.outerIndex = n + 1;
            if (this.getIndex() != Arrays64Kt.getLastIndex(this.array)) {
                this.inner = this.array.getArray()[this.outerIndex];
            }
        } else {
            int n = this.innerIndex;
            this.innerIndex = n + 1;
        }
        long l = this.getIndex();
        this.index = l + 1L;
    }

    private final void decreaseIndices() {
        if (this.innerIndex == 0) {
            this.innerIndex = 0x7FFFFFF;
            int n = this.outerIndex;
            this.outerIndex = n + -1;
            if (this.getIndex() != 0L) {
                this.inner = this.array.getArray()[this.outerIndex];
            }
        } else {
            int n = this.innerIndex;
            this.innerIndex = n + -1;
        }
        long l = this.getIndex();
        this.index = l + -1L;
    }

    public FastIntArray64Iterator(@NotNull FastIntArray64 array, long index) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.array = array;
        this.index = index;
        this.outerIndex = BigArrays.segment((long)index);
        this.innerIndex = BigArrays.displacement((long)index);
        this.inner = this.array.getArray()[this.outerIndex];
    }
}

