/*
 * Decompiled with CFR 0.152.
 */
package io.github.millibyte1.array64;

import io.github.millibyte1.array64.FastLongArray64Iterator;
import io.github.millibyte1.array64.LongArray64;
import io.github.millibyte1.array64.LongArray64Iterator;
import it.unimi.dsi.fastutil.BigArrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\t\u001a\u00020\u0000H\u0016J\u0013\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u0016\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J\t\u0010\u001a\u001a\u00020\u001bH\u0096\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0003H\u0016J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0096\u0002R$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0000X\u0081\u0004\u00a2\u0006\u0010\n\u0002\u0010\u0011\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lio/github/millibyte1/array64/FastLongArray64;", "Lio/github/millibyte1/array64/LongArray64;", "size", "", "(J)V", "array", "(Lio/github/millibyte1/array64/FastLongArray64;)V", "", "", "copy", "", "([[JZ)V", "([JZ)V", "getArray$annotations", "()V", "getArray", "()[[J", "[[J", "getSize", "()J", "equals", "other", "", "get", "index", "(J)Ljava/lang/Long;", "iterator", "Lio/github/millibyte1/array64/LongArray64Iterator;", "set", "", "value", "Companion", "array64"})
public final class FastLongArray64
implements LongArray64 {
    private final long size;
    @NotNull
    private final long[][] array;
    public static final long MAX_SIZE = 288230376017494016L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public long getSize() {
        return this.size;
    }

    @PublishedApi
    public static /* synthetic */ void getArray$annotations() {
    }

    @NotNull
    public final long[][] getArray() {
        return this.array;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FastLongArray64)) {
            return false;
        }
        if (this.getSize() != ((FastLongArray64)other).getSize()) {
            return false;
        }
        LongArray64Iterator thisIterator = this.iterator();
        LongArray64Iterator otherIterator = ((FastLongArray64)other).iterator();
        while (thisIterator.hasNext()) {
            if (thisIterator.nextLong() == otherIterator.nextLong()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public FastLongArray64 copy() {
        return new FastLongArray64(this);
    }

    @Override
    @NotNull
    public Long get(long index) {
        if (index >= this.getSize() || index < 0L) {
            throw (Throwable)new NoSuchElementException();
        }
        return BigArrays.get((long[][])this.array, (long)index);
    }

    @Override
    public void set(long index, long value) {
        if (index >= this.getSize() || index < 0L) {
            throw (Throwable)new NoSuchElementException();
        }
        BigArrays.set((long[][])this.array, (long)index, (long)value);
    }

    @Override
    @NotNull
    public LongArray64Iterator iterator(long index) {
        if (index < 0L || index >= this.getSize()) {
            throw (Throwable)new IllegalArgumentException("Invalid index provided.");
        }
        return new FastLongArray64Iterator(this, index);
    }

    @Override
    @NotNull
    public LongArray64Iterator iterator() {
        return new FastLongArray64Iterator(this, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public FastLongArray64(long size) {
        long[][] lArray;
        FastLongArray64 fastLongArray64;
        if (size > 288230376017494016L || size <= 0L) {
            throw (Throwable)new IllegalArgumentException("Invalid size provided.");
        }
        this.size = size;
        int fullArrays = (int)(size / (long)0x8000000);
        int innerSize = (int)(size % (long)0x8000000);
        FastLongArray64 fastLongArray642 = this;
        if (innerSize == 0) {
            long[][] lArrayArray;
            FastLongArray64 fastLongArray643 = fastLongArray642;
            long[][] lArrayArray2 = new long[fullArrays][];
            int n = 0;
            while (n < fullArrays) {
                int n2 = n;
                int n3 = n++;
                lArrayArray = lArrayArray2;
                boolean bl = false;
                long[] lArray2 = new long[0x8000000];
                lArrayArray[n3] = lArray2;
            }
            lArrayArray = lArrayArray2;
            fastLongArray64 = fastLongArray643;
            lArray = lArrayArray;
        } else {
            long[][] lArrayArray;
            int n = fullArrays + 1;
            FastLongArray64 fastLongArray644 = fastLongArray642;
            long[][] lArrayArray3 = new long[n][];
            for (int i = 0; i < n; ++i) {
                void i2;
                int bl = i;
                int n4 = i;
                lArrayArray = lArrayArray3;
                boolean bl2 = false;
                long[] lArray3 = i2 == fullArrays ? new long[innerSize] : new long[0x8000000];
                lArrayArray[n4] = lArray3;
            }
            lArrayArray = lArrayArray3;
            fastLongArray64 = fastLongArray644;
            lArray = lArrayArray;
        }
        fastLongArray64.array = lArray;
    }

    public FastLongArray64(@NotNull FastLongArray64 array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this(array.array, false, 2, null);
    }

    public FastLongArray64(@NotNull long[][] array, boolean copy) {
        long[][] lArray;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.size = BigArrays.length((long[][])array);
        if (copy) {
            long[][] lArray2 = BigArrays.copy((long[][])array);
            lArray = lArray2;
            Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"BigArrays.copy(array)");
        } else {
            lArray = array;
        }
        this.array = lArray;
    }

    public /* synthetic */ FastLongArray64(long[][] lArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(lArray, bl);
    }

    public FastLongArray64(@NotNull long[] array, boolean copy) {
        long[][] lArray;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.size = array.length;
        FastLongArray64 fastLongArray64 = this;
        if (copy) {
            long[][] lArray2 = BigArrays.wrap((long[])array);
            lArray = lArray2;
            Intrinsics.checkNotNullExpressionValue((Object)lArray2, (String)"BigArrays.wrap(array)");
        } else {
            long[][] lArrayArray;
            int n = 1;
            FastLongArray64 fastLongArray642 = fastLongArray64;
            long[][] lArrayArray2 = new long[n][];
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                int n4 = n2++;
                lArrayArray = lArrayArray2;
                boolean bl = false;
                long[] lArray3 = array;
                lArrayArray[n4] = lArray3;
            }
            lArrayArray = lArrayArray2;
            fastLongArray64 = fastLongArray642;
            lArray = lArrayArray;
        }
        fastLongArray64.array = lArray;
    }

    public /* synthetic */ FastLongArray64(long[] lArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(lArray, bl);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\tH\u0086\n\u00f8\u0001\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\n"}, d2={"Lio/github/millibyte1/array64/FastLongArray64$Companion;", "", "()V", "MAX_SIZE", "", "invoke", "Lio/github/millibyte1/array64/FastLongArray64;", "size", "init", "Lkotlin/Function1;", "array64"})
    public static final class Companion {
        @NotNull
        public final FastLongArray64 invoke(long size, @NotNull Function1<? super Long, Long> init) {
            int $i$f$invoke = 0;
            Intrinsics.checkNotNullParameter(init, (String)"init");
            FastLongArray64 retval = new FastLongArray64(size);
            long index = 0L;
            for (long[] inner : retval.getArray()) {
                for (int innerIndex = 0; innerIndex < inner.length; ++innerIndex) {
                    inner[innerIndex] = ((Number)init.invoke((Object)index)).longValue();
                    long l = index;
                    index = l + 1L;
                }
            }
            return retval;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

