/*
 * Decompiled with CFR 0.152.
 */
package io.github.millibyte1.array64;

import io.github.millibyte1.array64.FastShortArray64Iterator;
import io.github.millibyte1.array64.ShortArray64;
import io.github.millibyte1.array64.ShortArray64Iterator;
import it.unimi.dsi.fastutil.BigArrays;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0017\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0006B\u001f\b\u0016\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\t\u001a\u00020\u0000H\u0016J\u0013\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\t\u0010\u001b\u001a\u00020\u001cH\u0096\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0019\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0018H\u0096\u0002R$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0000X\u0081\u0004\u00a2\u0006\u0010\n\u0002\u0010\u0011\u0012\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lio/github/millibyte1/array64/FastShortArray64;", "Lio/github/millibyte1/array64/ShortArray64;", "size", "", "(J)V", "array", "(Lio/github/millibyte1/array64/FastShortArray64;)V", "", "", "copy", "", "([[SZ)V", "([SZ)V", "getArray$annotations", "()V", "getArray", "()[[S", "[[S", "getSize", "()J", "equals", "other", "", "get", "", "index", "(J)Ljava/lang/Short;", "iterator", "Lio/github/millibyte1/array64/ShortArray64Iterator;", "set", "", "value", "Companion", "array64"})
public final class FastShortArray64
implements ShortArray64 {
    private final long size;
    @NotNull
    private final short[][] array;
    public static final long MAX_SIZE = 288230376017494016L;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public long getSize() {
        return this.size;
    }

    @PublishedApi
    public static /* synthetic */ void getArray$annotations() {
    }

    @NotNull
    public final short[][] getArray() {
        return this.array;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FastShortArray64)) {
            return false;
        }
        if (this.getSize() != ((FastShortArray64)other).getSize()) {
            return false;
        }
        ShortArray64Iterator thisIterator = this.iterator();
        ShortArray64Iterator otherIterator = ((FastShortArray64)other).iterator();
        while (thisIterator.hasNext()) {
            if (thisIterator.nextShort() == otherIterator.nextShort()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public FastShortArray64 copy() {
        return new FastShortArray64(this);
    }

    @Override
    @NotNull
    public Short get(long index) {
        if (index >= this.getSize() || index < 0L) {
            throw (Throwable)new NoSuchElementException();
        }
        return BigArrays.get((short[][])this.array, (long)index);
    }

    @Override
    public void set(long index, short value) {
        if (index >= this.getSize() || index < 0L) {
            throw (Throwable)new NoSuchElementException();
        }
        BigArrays.set((short[][])this.array, (long)index, (short)value);
    }

    @Override
    @NotNull
    public ShortArray64Iterator iterator(long index) {
        if (index < 0L || index >= this.getSize()) {
            throw (Throwable)new IllegalArgumentException("Invalid index provided.");
        }
        return new FastShortArray64Iterator(this, index);
    }

    @Override
    @NotNull
    public ShortArray64Iterator iterator() {
        return new FastShortArray64Iterator(this, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public FastShortArray64(long size) {
        short[][] sArray;
        FastShortArray64 fastShortArray64;
        if (size > 288230376017494016L || size <= 0L) {
            throw (Throwable)new IllegalArgumentException("Invalid size provided.");
        }
        this.size = size;
        int fullArrays = (int)(size / (long)0x8000000);
        int innerSize = (int)(size % (long)0x8000000);
        FastShortArray64 fastShortArray642 = this;
        if (innerSize == 0) {
            short[][] sArrayArray;
            FastShortArray64 fastShortArray643 = fastShortArray642;
            short[][] sArrayArray2 = new short[fullArrays][];
            int n = 0;
            while (n < fullArrays) {
                int n2 = n;
                int n3 = n++;
                sArrayArray = sArrayArray2;
                boolean bl = false;
                short[] sArray2 = new short[0x8000000];
                sArrayArray[n3] = sArray2;
            }
            sArrayArray = sArrayArray2;
            fastShortArray64 = fastShortArray643;
            sArray = sArrayArray;
        } else {
            short[][] sArrayArray;
            int n = fullArrays + 1;
            FastShortArray64 fastShortArray644 = fastShortArray642;
            short[][] sArrayArray3 = new short[n][];
            for (int i = 0; i < n; ++i) {
                void i2;
                int bl = i;
                int n4 = i;
                sArrayArray = sArrayArray3;
                boolean bl2 = false;
                short[] sArray3 = i2 == fullArrays ? new short[innerSize] : new short[0x8000000];
                sArrayArray[n4] = sArray3;
            }
            sArrayArray = sArrayArray3;
            fastShortArray64 = fastShortArray644;
            sArray = sArrayArray;
        }
        fastShortArray64.array = sArray;
    }

    public FastShortArray64(@NotNull FastShortArray64 array) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this(array.array, false, 2, null);
    }

    public FastShortArray64(@NotNull short[][] array, boolean copy) {
        short[][] sArray;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.size = BigArrays.length((short[][])array);
        if (copy) {
            short[][] sArray2 = BigArrays.copy((short[][])array);
            sArray = sArray2;
            Intrinsics.checkNotNullExpressionValue((Object)sArray2, (String)"BigArrays.copy(array)");
        } else {
            sArray = array;
        }
        this.array = sArray;
    }

    public /* synthetic */ FastShortArray64(short[][] sArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(sArray, bl);
    }

    public FastShortArray64(@NotNull short[] array, boolean copy) {
        short[][] sArray;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.size = array.length;
        FastShortArray64 fastShortArray64 = this;
        if (copy) {
            short[][] sArray2 = BigArrays.wrap((short[])array);
            sArray = sArray2;
            Intrinsics.checkNotNullExpressionValue((Object)sArray2, (String)"BigArrays.wrap(array)");
        } else {
            short[][] sArrayArray;
            int n = 1;
            FastShortArray64 fastShortArray642 = fastShortArray64;
            short[][] sArrayArray2 = new short[n][];
            int n2 = 0;
            while (n2 < n) {
                int n3 = n2;
                int n4 = n2++;
                sArrayArray = sArrayArray2;
                boolean bl = false;
                short[] sArray3 = array;
                sArrayArray[n4] = sArray3;
            }
            sArrayArray = sArrayArray2;
            fastShortArray64 = fastShortArray642;
            sArray = sArrayArray;
        }
        fastShortArray64.array = sArray;
    }

    public /* synthetic */ FastShortArray64(short[] sArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(sArray, bl);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\n\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\tH\u0086\n\u00f8\u0001\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000b"}, d2={"Lio/github/millibyte1/array64/FastShortArray64$Companion;", "", "()V", "MAX_SIZE", "", "invoke", "Lio/github/millibyte1/array64/FastShortArray64;", "size", "init", "Lkotlin/Function1;", "", "array64"})
    public static final class Companion {
        @NotNull
        public final FastShortArray64 invoke(long size, @NotNull Function1<? super Long, Short> init) {
            int $i$f$invoke = 0;
            Intrinsics.checkNotNullParameter(init, (String)"init");
            FastShortArray64 retval = new FastShortArray64(size);
            long index = 0L;
            for (short[] inner : retval.getArray()) {
                for (int innerIndex = 0; innerIndex < inner.length; ++innerIndex) {
                    inner[innerIndex] = ((Number)init.invoke((Object)index)).shortValue();
                    long l = index;
                    index = l + 1L;
                }
            }
            return retval;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

