/*
 * Decompiled with CFR 0.152.
 */
package ArmyC2.C2SD.Rendering;

import ArmyC2.C2SD.Rendering.IJavaRenderer;
import ArmyC2.C2SD.Rendering.MultiPointRenderer;
import ArmyC2.C2SD.Rendering.SinglePointRenderer;
import ArmyC2.C2SD.Rendering.TacticalGraphicIconRenderer;
import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.IMultiPointRenderer;
import ArmyC2.C2SD.Utilities.IPointConversion;
import ArmyC2.C2SD.Utilities.ImageInfo;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.PointConversion;
import ArmyC2.C2SD.Utilities.PointConversionDummy;
import ArmyC2.C2SD.Utilities.RendererException;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.SinglePointLookup;
import ArmyC2.C2SD.Utilities.SymbolDef;
import ArmyC2.C2SD.Utilities.SymbolDefTable;
import ArmyC2.C2SD.Utilities.SymbolDraw;
import ArmyC2.C2SD.Utilities.SymbolUtilities;
import ArmyC2.C2SD.Utilities.UnitDef;
import ArmyC2.C2SD.Utilities.UnitDefTable;
import ArmyC2.C2SD.Utilities.UnitFontLookup;
import ArmyC2.C2SD.Utilities.UnitFontLookupInfo;
import RenderMultipoints.clsRenderer;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class JavaRenderer
implements IJavaRenderer {
    private static JavaRenderer _instance = null;
    private static String _className = "";
    private static SinglePointRenderer _SPR = null;
    private static IMultiPointRenderer _MPR = null;
    private static TacticalGraphicIconRenderer _TGIR = null;
    private SymbolDefTable _SymbolDefTable = null;
    PointConversion _PointConverter = null;
    public static final int UnitSizeMedium = 40;
    public static final int UnitSizeSmall = 30;
    public static final int UnitSizeLarge = 50;
    public static final int UnitSizeXL = 60;
    public static final int SymbolSizeMedium = 80;
    public static final int SymbolSizeSmall = 60;
    public static final int SymbolSizeLarge = 100;
    public static final int SymbolSizeXL = 120;

    private JavaRenderer() {
        try {
            _SPR = SinglePointRenderer.getInstance();
            _MPR = MultiPointRenderer.getInstance();
            _TGIR = TacticalGraphicIconRenderer.getInstance();
            _className = this.getClass().getName();
            if (_SPR == null) {
                System.err.println("JavaRenderer failed to initialize - SinglePointRenderer didn't load.");
            }
            if (_TGIR == null) {
                System.err.println("JavaRenderer failed to initialize - TacticalGraphicIconRenderer didn't load.");
            }
        }
        catch (Exception exc) {
            System.err.println("JavaRenderer failed to initialize");
            System.err.println(exc.getMessage());
        }
    }

    public static synchronized JavaRenderer getInstance() {
        if (_instance == null) {
            _instance = new JavaRenderer();
        }
        return _instance;
    }

    @Override
    public Boolean CanRender(MilStdSymbol symbol) {
        return this.CanRender(symbol.getSymbolID(), symbol.getCoordinates(), symbol.getSymbologyStandard());
    }

    @Override
    public Boolean CanRender(String symbolCode, ArrayList<Point2D.Double> coords) {
        return this.CanRender(symbolCode, coords, RendererSettings.getInstance().getSymbologyStandard());
    }

    @Override
    public Boolean CanRender(String symbolCode, ArrayList<Point2D.Double> coords, int symStd) {
        String message = null;
        String basicSymbolID = symbolCode;
        basicSymbolID = SymbolUtilities.getBasicSymbolIDStrict((String)basicSymbolID);
        try {
            if (SymbolUtilities.isTacticalGraphic((String)basicSymbolID)) {
                SymbolDef sd;
                if (this._SymbolDefTable == null) {
                    this._SymbolDefTable = SymbolDefTable.getInstance();
                }
                if ((sd = this._SymbolDefTable.getSymbolDef(basicSymbolID, symStd)) != null) {
                    int dc;
                    int pointCount = 0;
                    if (coords != null) {
                        pointCount = coords.size();
                    }
                    if ((dc = sd.getDrawCategory()) == 8) {
                        int index = -1;
                        index = SinglePointLookup.getInstance().getCharCodeFromSymbol(symbolCode, symStd);
                        if (index > 0) {
                            return true;
                        }
                        message = "Bad font lookup for: " + symbolCode + " (" + basicSymbolID + ")";
                    } else if (dc > 0 && dc < 99) {
                        if (sd.getMinPoints() == sd.getMaxPoints()) {
                            if (pointCount == sd.getMinPoints()) {
                                return true;
                            }
                            message = "Specific point count not met for: " + symbolCode + " (" + basicSymbolID + ") - Had: " + String.valueOf(pointCount) + " Needed: " + String.valueOf(sd.getMinPoints());
                        } else {
                            if (pointCount >= sd.getMinPoints()) {
                                return true;
                            }
                            if (sd.getDrawCategory() == 3 && pointCount == 2 && sd.getMinPoints() == 3 && sd.getMaxPoints() > 100) {
                                return true;
                            }
                            if (pointCount < sd.getMinPoints()) {
                                message = symbolCode + " had less than the required number of points. Had: " + String.valueOf(coords.size()) + " Needed: " + String.valueOf(sd.getMinPoints());
                            }
                        }
                    } else {
                        message = "Cannot draw: " + symbolCode + " (" + basicSymbolID + ")";
                    }
                } else {
                    message = "Cannot draw symbolID: " + symbolCode + " (" + basicSymbolID + ")";
                }
            } else {
                UnitFontLookupInfo ufli = UnitFontLookup.getInstance().getLookupInfo(basicSymbolID, symStd);
                if (ufli != null) {
                    return true;
                }
                message = "JavaRenderer.CanRender() - Cannot draw symbolID: " + symbolCode + " (" + basicSymbolID + ")";
            }
            if (message != null && !message.equals("")) {
                ErrorLogger.LogMessage((String)this.getClass().getName(), (String)"CanRender()", (String)message, (Level)Level.FINE);
            }
        }
        catch (Exception exc) {
            System.err.println(String.valueOf(message));
            System.err.println(exc.getMessage());
        }
        return false;
    }

    @Override
    public MilStdSymbol Render(MilStdSymbol symbol, IPointConversion converter, Rectangle2D clipBounds) throws RendererException {
        this.ProcessSymbolGeometry(symbol, converter, clipBounds);
        return symbol;
    }

    @Override
    public ArrayList<MilStdSymbol> Render(ArrayList<MilStdSymbol> symbols, IPointConversion converter, Rectangle2D clipBounds) throws RendererException {
        this.ProcessSymbolGeometryBulk(symbols, converter, clipBounds);
        return symbols;
    }

    @Override
    public MilStdSymbol Render(String symbolCode, String UUID, ArrayList<Point2D.Double> coords, Map<String, String> Modifiers, IPointConversion converter, Rectangle2D clipBounds) throws RendererException {
        MilStdSymbol symbol = null;
        symbol = new MilStdSymbol(symbolCode, UUID, coords, Modifiers);
        this.ProcessSymbolGeometry(symbol, converter, clipBounds);
        return symbol;
    }

    @Override
    public ImageInfo RenderSinglePointAsImageInfo(String symbolCode, Map<String, String> Modifiers, int unitSize, boolean keepUnitRatio) {
        return this.RenderSinglePointAsImageInfo(symbolCode, Modifiers, unitSize, keepUnitRatio, RendererSettings.getInstance().getSymbologyStandard());
    }

    public ImageInfo RenderSinglePointAsImageInfo(String symbolCode, Map<String, String> Modifiers, int unitSize, boolean keepUnitRatio, int symStd) {
        ImageInfo returnVal = null;
        try {
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            points.add(new Point2D.Double(0.0, 0.0));
            PointConversionDummy ipc = new PointConversionDummy();
            MilStdSymbol symbol = null;
            symbol = new MilStdSymbol(symbolCode, null, points, Modifiers);
            symbol.setUnitSize(unitSize);
            symbol.setKeepUnitRatio(Boolean.valueOf(keepUnitRatio));
            symbol.setSymbologyStandard(symStd);
            if (Modifiers.containsKey("LINECOLOR")) {
                symbol.setLineColor(SymbolUtilities.getColorFromHexString((String)Modifiers.get("LINECOLOR")));
            }
            if (Modifiers.containsKey("FILLCOLOR")) {
                symbol.setFillColor(SymbolUtilities.getColorFromHexString((String)Modifiers.get("FILLCOLOR")));
            }
            if (Modifiers.containsKey("ICONCOLOR")) {
                symbol.setIconColor(SymbolUtilities.getColorFromHexString((String)Modifiers.get("ICONCOLOR")));
            }
            this.ProcessSymbolGeometry(symbol, (IPointConversion)ipc, null);
            returnVal = symbol.toImageInfo();
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
        }
        return returnVal;
    }

    public ImageInfo RenderMilStdSymbolAsImageInfo(String symbolCode, String UUID, ArrayList<Point2D.Double> coords, Map<String, String> Modifiers, IPointConversion converter, Rectangle2D clipBounds) {
        ImageInfo returnVal = null;
        try {
            MilStdSymbol symbol = new MilStdSymbol(symbolCode, UUID, coords, Modifiers);
            this.ProcessSymbolGeometry(symbol, converter, clipBounds);
            returnVal = symbol.toImageInfo();
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
        }
        return returnVal;
    }

    public ImageInfo RenderMilStdSymbolAsImageInfo(MilStdSymbol symbol, IPointConversion converter, Rectangle2D clipBounds) {
        ImageInfo returnVal = null;
        try {
            this.ProcessSymbolGeometry(symbol, converter, clipBounds);
            returnVal = symbol.toImageInfo();
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
        }
        return returnVal;
    }

    @Override
    public BufferedImage RenderMilStdSymbolAsIcon(String symbolID, int iconSize, Boolean showDisplayModifiers) {
        return this.RenderMilStdSymbolAsIcon(symbolID, iconSize, showDisplayModifiers, RendererSettings.getInstance().getSymbologyStandard());
    }

    public BufferedImage RenderMilStdSymbolAsIcon(String symbolID, int iconSize, Boolean showDisplayModifiers, int symStd) {
        BufferedImage returnVal = null;
        try {
            ImageInfo ii = null;
            SymbolDef sd = null;
            HashMap<String, String> Modifiers = new HashMap<String, String>();
            ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
            points.add(new Point2D.Double(0.0, 0.0));
            MilStdSymbol symbol = null;
            symbol = new MilStdSymbol(symbolID, null, points, Modifiers);
            if (showDisplayModifiers.booleanValue()) {
                symbol.setDrawAffiliationModifierAsLabel(false);
            }
            symbol.setModifier("showdisplaymodifiers", showDisplayModifiers.toString());
            ii = SymbolUtilities.isTacticalGraphic((String)symbolID) ? ((sd = SymbolDefTable.getInstance().getSymbolDef(SymbolUtilities.getBasicSymbolID((String)symbolID), symStd)) != null && sd.getDrawCategory() != 8 ? _TGIR.getIcon(symbolID, iconSize, null, symbol.getSymbologyStandard()) : this.RenderSinglePointAsImageInfo(symbolID, Modifiers, iconSize, false)) : this.RenderSinglePointAsImageInfo(symbolID, Modifiers, iconSize, false);
            returnVal = showDisplayModifiers == true ? ImageInfo.getScaledInstance((BufferedImage)ii.getImage(), (int)iconSize, (int)iconSize, (Object)RenderingHints.VALUE_INTERPOLATION_BILINEAR, (boolean)false, (boolean)true) : ii.getImage();
            int type = returnVal.getTransparency() == 1 ? 1 : 2;
            int w = iconSize;
            int h = iconSize;
            int x = 0;
            int y = 0;
            BufferedImage tmp = new BufferedImage(w, h, type);
            int ow = returnVal.getWidth();
            int oh = returnVal.getHeight();
            if (ow < w) {
                x = (w - ow) / 2;
                w -= x;
            }
            if (oh < h) {
                y = (h - oh) / 2;
                h -= y;
            }
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g2.drawImage(returnVal, x, y, w, h, null);
            g2.dispose();
            returnVal = tmp;
        }
        catch (Exception exc) {
            System.err.println(exc.getMessage());
        }
        return returnVal;
    }

    @Override
    public void DrawDB(MilStdSymbol symbol, Graphics2D destination, Rectangle clip) throws RendererException {
        ArrayList<MilStdSymbol> symbols = new ArrayList<MilStdSymbol>();
        symbols.add(symbol);
        this.DrawDB(symbols, destination, clip);
    }

    @Override
    public void DrawDB(ArrayList<MilStdSymbol> symbols, Graphics2D destination, Rectangle clip) throws RendererException {
        try {
            if (symbols == null || destination == null || clip == null || clip.width <= 0 || clip.height <= 0) {
                String badValues = "Bad parameters passed: ";
                if (symbols == null) {
                    badValues = badValues + " symbols";
                }
                if (destination == null) {
                    badValues = badValues + " destination";
                }
                if (clip == null) {
                    badValues = badValues + " clip";
                } else {
                    if (clip.width < 1) {
                        badValues = badValues + " clip.width";
                    }
                    if (clip.height < 1) {
                        badValues = badValues + " clip.height";
                    }
                }
                RendererException re = new RendererException(badValues, null);
                ErrorLogger.LogException((String)this.getClass().getName(), (String)"DrawDB()", (Exception)re);
                throw re;
            }
            BufferedImage buffer = new BufferedImage(clip.width, clip.height, 2);
            Graphics2D graphics = buffer.createGraphics();
            this.Draw(symbols, graphics, -clip.x, -clip.y);
            destination.drawImage((Image)buffer, clip.x, clip.y, null);
            graphics.dispose();
            graphics = null;
            buffer.flush();
            buffer = null;
        }
        catch (Exception exc) {
            RendererException re2 = new RendererException("Draw Operation Failed", (Throwable)exc);
            System.err.println(exc.getMessage());
            throw re2;
        }
    }

    @Override
    public void Draw(MilStdSymbol symbol, Graphics2D destination) throws RendererException {
        ArrayList<MilStdSymbol> symbols = new ArrayList<MilStdSymbol>();
        symbols.add(symbol);
        this.Draw(symbols, destination, 0, 0);
    }

    @Override
    public void Draw(ArrayList<MilStdSymbol> symbols, Graphics2D destination) throws RendererException {
        this.Draw(symbols, destination, 0, 0);
    }

    private void Draw(ArrayList<MilStdSymbol> symbols, Graphics2D destination, int offsetX, int offsetY) throws RendererException {
        try {
            if (symbols == null || destination == null) {
                String badValues = "Bad parameters passed: ";
                if (symbols == null) {
                    badValues = badValues + " symbols";
                }
                if (destination == null) {
                    badValues = badValues + " destination";
                }
                RendererException re = new RendererException(badValues, null);
                System.err.println(re.getMessage());
                throw re;
            }
            SymbolDraw.Draw(symbols, (Graphics2D)destination, (int)offsetX, (int)offsetY);
        }
        catch (Exception exc) {
            RendererException re2 = new RendererException("Draw Operation Failed", (Throwable)exc);
            ErrorLogger.LogException((String)this.getClass().getName(), (String)"Draw()", (Exception)re2);
            throw re2;
        }
    }

    @Override
    public Map<String, UnitDef> getSupportedFETypes(int symStd) {
        return UnitDefTable.getInstance().GetAllUnitDefs(symStd);
    }

    @Override
    public Map<String, SymbolDef> getSupportedTGTypes(int symStd) {
        Map defs = SymbolDefTable.getInstance().GetAllSymbolDefs(symStd);
        HashMap<String, SymbolDef> types = new HashMap<String, SymbolDef>();
        Collection symbols = defs.values();
        for (SymbolDef item : symbols) {
            if (SymbolUtilities.isMCSSpecificTacticalGraphic((SymbolDef)item)) continue;
            types.put(item.getBasicSymbolId(), item);
        }
        return types;
    }

    public void initialize(Map<String, String> arg0) {
    }

    public static void setLoggingLevel(Level newLevel) {
        ErrorLogger.setLevel((Level)newLevel);
    }

    @Override
    public int getSinglePointTGSymbolSize() {
        return _SPR.getSinglePointTGSymbolSize();
    }

    @Override
    public int getUnitSymbolSize() {
        return _SPR.getUnitSymbolSize();
    }

    @Override
    public void setSinglePointTGSymbolSize(int size) {
        _SPR.setSinglePointTGSymbolSize(size);
    }

    @Override
    public void setUnitSymbolSize(int size) {
        _SPR.setUnitSymbolSize(size);
    }

    @Override
    public void setModifierFont(String name, int type, int size) {
        RendererSettings.getInstance().setLabelFont(name, type, size);
        _SPR.RefreshModifierFont();
    }

    @Override
    public void setModifierFont(String name, int type, int size, float tracking, Boolean kerning) {
        RendererSettings.getInstance().setLabelFont(name, type, size, kerning, tracking);
        _SPR.RefreshModifierFont();
    }

    private void ProcessSymbolGeometry(MilStdSymbol symbol, IPointConversion converter, Rectangle2D clipBounds) throws RendererException {
        ArrayList<MilStdSymbol> symbols = new ArrayList<MilStdSymbol>();
        symbols.add(symbol);
        this.ProcessSymbolGeometryBulk(symbols, converter, clipBounds);
    }

    private void ProcessSymbolGeometryBulk(ArrayList<MilStdSymbol> symbols, IPointConversion converter, Rectangle2D clipBounds) throws RendererException {
        try {
            String basicSymbolID = "";
            int count = symbols.size();
            String message = null;
            String symbolID = null;
            SymbolDef symbolDef = null;
            if (this._SymbolDefTable == null) {
                this._SymbolDefTable = SymbolDefTable.getInstance();
            }
            for (int lcv = 0; lcv < count; ++lcv) {
                MilStdSymbol symbol = symbols.get(lcv);
                int pointCount = 0;
                if (symbol.getCoordinates() != null) {
                    pointCount = symbol.getCoordinates().size();
                }
                if (SymbolUtilities.isTacticalGraphic((String)(symbolID = symbol.getSymbolID())) || pointCount > 1) {
                    basicSymbolID = SymbolUtilities.getBasicSymbolID((String)symbol.getSymbolID());
                    symbolDef = this._SymbolDefTable.getSymbolDef(basicSymbolID, symbol.getSymbologyStandard());
                    if (symbolDef == null) {
                        if (symbol.getCoordinates().size() <= 1) {
                            if (symbol.getModifier("H") != null) {
                                symbol.setModifier("H1", symbol.getModifier("H"));
                            }
                            symbol.setModifier("H", symbolID.substring(0, 10));
                            symbol.setSymbolID("G" + SymbolUtilities.getAffiliation((String)symbolID) + "G" + SymbolUtilities.getStatus((String)symbolID) + "GPP---****X");
                            symbol.setLineColor(SymbolUtilities.getLineColorOfAffiliation((String)symbolID));
                            symbol.setFillColor(SymbolUtilities.getFillColorOfAffiliation((String)symbolID));
                        } else {
                            symbol.setSymbolID("G" + SymbolUtilities.getAffiliation((String)symbolID) + "G" + SymbolUtilities.getStatus((String)symbolID) + "GLB---****X");
                            symbol.setLineColor(SymbolUtilities.getLineColorOfAffiliation((String)symbolID));
                            symbol.setFillColor(null);
                        }
                        basicSymbolID = SymbolUtilities.getBasicSymbolID((String)symbol.getSymbolID());
                        symbolDef = this._SymbolDefTable.getSymbolDef(basicSymbolID, symbol.getSymbologyStandard());
                    }
                    if (symbolDef != null) {
                        if (symbolDef.getDrawCategory() == 8) {
                            _SPR.ProcessSPSymbol(symbol, converter);
                            continue;
                        }
                        _MPR.render(symbol, converter, (Object)clipBounds);
                        continue;
                    }
                    message = "Cannot draw: " + symbolID + " (" + basicSymbolID + "), lookup failed.";
                    throw new RendererException(message);
                }
                _SPR.ProcessUnitSymbol(symbol, converter);
            }
        }
        catch (Exception exc) {
            throw new RendererException(exc.getMessage(), (Throwable)exc);
        }
    }

    private void ProcessTGSymbol(MilStdSymbol symbol, IPointConversion converter, Rectangle2D clipBounds) {
        try {
            if (SymbolUtilities.getBasicSymbolID((String)symbol.getSymbolID()).equals("G*F*AXS---****X") && symbol.getModifiers_AM_AN_X("AN") != null && symbol.getModifiers_AM_AN_X("AM") != null) {
                int anCount = symbol.getModifiers_AM_AN_X("AN").size();
                int amCount = symbol.getModifiers_AM_AN_X("AM").size();
                ArrayList am = null;
                if (amCount < anCount / 2 + 1 && (Double)(am = symbol.getModifiers_AM_AN_X("AM")).get(0) != 0.0) {
                    am.add(0, 0.0);
                }
            }
            ArrayList shapes = new ArrayList();
            ArrayList modifiers = new ArrayList();
            clsRenderer.render((MilStdSymbol)symbol, (IPointConversion)converter, shapes, modifiers, (Object)clipBounds);
            if (RendererSettings.getInstance().getTextBackgroundMethod() != 0) {
                modifiers = SymbolDraw.ProcessModifierBackgrounds(modifiers);
                symbol.setModifierShapes(modifiers);
            }
        }
        catch (Exception exc) {
            String message = "Failed to build multipoint TG";
            if (symbol != null) {
                message = message + ": " + symbol.getSymbolID();
            }
            System.err.println(exc.getMessage());
        }
        catch (Throwable t) {
            String message2 = "Failed to build multipoint TG";
            if (symbol != null) {
                message2 = message2 + ": " + symbol.getSymbolID();
            }
            System.err.println(t.getMessage());
        }
    }
}

