/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.lassp.houle.RngPack;

import edu.cornell.lassp.houle.RngPack.RandomSeedable;
import java.io.Serializable;
import java.util.Date;

public class Ranlux
extends RandomSeedable
implements Serializable {
    public static final int maxlev = 4;
    public static final int lxdflt = 3;
    static final int igiga = 1000000000;
    static final int jsdflt = 314159265;
    static final int twop12 = 4096;
    static final int itwo24 = 0x1000000;
    static final int icons = 2147483563;
    static final int[] ndskip = new int[]{0, 24, 73, 199, 365};
    int[] iseeds;
    int[] isdext;
    int[] next;
    int luxlev = 3;
    int nskip;
    int inseed;
    int jseed;
    int in24 = 0;
    int kount = 0;
    int mkount = 0;
    int i24 = 24;
    int j24 = 10;
    float[] seeds;
    float carry = 0.0f;
    float twom24;
    float twom12;
    boolean diagOn = false;

    public Ranlux() {
        this.init_arrays();
        this.rluxdef();
    }

    public Ranlux(int lux, int ins) {
        this.init_arrays();
        this.rluxgo(lux, Math.abs(ins));
    }

    public Ranlux(int lux, long ins) {
        this.init_arrays();
        this.rluxgo(lux, Math.abs((int)(ins % Integer.MAX_VALUE)));
    }

    public Ranlux(int ins) {
        this.init_arrays();
        this.rluxgo(3, Math.abs(ins));
    }

    public Ranlux(long ins) {
        this.init_arrays();
        this.rluxgo(3, Math.abs((int)(ins % Integer.MAX_VALUE)));
    }

    public Ranlux(int lux, Date d) {
        this.init_arrays();
        this.rluxgo(lux, (int)(Ranlux.ClockSeed(d) % Integer.MAX_VALUE));
    }

    public Ranlux(Date d) {
        this.init_arrays();
        this.rluxgo(3, (int)(Ranlux.ClockSeed(d) % Integer.MAX_VALUE));
    }

    public void setDiag(boolean b) {
        this.diagOn = b;
    }

    @Override
    public final double raw() {
        float uni = this.seeds[this.j24] - this.seeds[this.i24] - this.carry;
        if (uni < 0.0f) {
            uni += 1.0f;
            this.carry = this.twom24;
        } else {
            this.carry = 0.0f;
        }
        this.seeds[this.i24] = uni;
        this.i24 = this.next[this.i24];
        this.j24 = this.next[this.j24];
        float out = uni;
        if (uni < this.twom12) {
            out += this.twom24 * this.seeds[this.j24];
        }
        if ((double)out == 0.0) {
            out = this.twom24 * this.twom24;
        }
        ++this.in24;
        if (this.in24 == 24) {
            this.in24 = 0;
            this.kount += this.nskip;
            for (int i = 1; i <= this.nskip; ++i) {
                uni = this.seeds[this.j24] - this.seeds[this.i24] - this.carry;
                if (uni < 0.0f) {
                    uni += 1.0f;
                    this.carry = this.twom24;
                } else {
                    this.carry = 0.0f;
                }
                this.seeds[this.i24] = uni;
                this.i24 = this.next[this.i24];
                this.j24 = this.next[this.j24];
            }
        }
        ++this.kount;
        if (this.kount >= 1000000000) {
            ++this.mkount;
            this.kount -= 1000000000;
        }
        return out;
    }

    private void init_arrays() {
        this.iseeds = new int[25];
        this.isdext = new int[26];
        this.next = new int[25];
        this.seeds = new float[25];
    }

    private void rluxdef() {
        int i;
        this.inseed = this.jseed = 314159265;
        this.diag("RANLUX DEFAULT INITIALIZATION: " + this.jseed);
        this.luxlev = 3;
        this.nskip = ndskip[this.luxlev];
        int lp = this.nskip + 24;
        this.in24 = 0;
        this.kount = 0;
        this.mkount = 0;
        this.diag("RANLUX DEFAULT LUXURY LEVEL =  " + this.luxlev + "    p = " + lp);
        this.twom24 = 1.0f;
        for (i = 1; i <= 24; ++i) {
            this.twom24 *= 0.5f;
            int k = this.jseed / 53668;
            this.jseed = 40014 * (this.jseed - k * 53668) - k * 12211;
            if (this.jseed < 0) {
                this.jseed += 2147483563;
            }
            this.iseeds[i] = this.jseed % 0x1000000;
        }
        this.twom12 = this.twom24 * 4096.0f;
        for (i = 1; i <= 24; ++i) {
            this.seeds[i] = (float)this.iseeds[i] * this.twom24;
            this.next[i] = i - 1;
        }
        this.next[1] = 24;
        this.i24 = 24;
        this.j24 = 10;
        this.carry = 0.0f;
        if ((double)this.seeds[24] == 0.0) {
            this.carry = this.twom24;
        }
    }

    private final void rluxgo(int lux, int ins) {
        int i;
        if (lux < 0) {
            this.luxlev = 3;
        } else if (lux <= 4) {
            this.luxlev = lux;
        } else if (lux < 24 || lux > 2000) {
            this.luxlev = 4;
            this.diag("RANLUX ILLEGAL LUXURY RLUXGO: " + lux);
        } else {
            this.luxlev = lux;
            for (int ilx = 0; ilx <= 4; ++ilx) {
                if (lux != ndskip[ilx] + 24) continue;
                this.luxlev = ilx;
            }
        }
        if (this.luxlev <= 4) {
            this.nskip = ndskip[this.luxlev];
            this.diag("RANLUX LUXURY LEVEL SET BY RLUXGO : " + this.luxlev + " P= " + (this.nskip + 24));
        } else {
            this.nskip = this.luxlev - 24;
            this.diag("RANLUX P-VALUE SET BY RLUXGO TO: " + this.luxlev);
        }
        this.in24 = 0;
        if (ins < 0) {
            this.diag("Illegal initialization by RLUXGO, negative input seed");
        }
        if (ins > 0) {
            this.jseed = ins;
            this.diag("RANLUX INITIALIZED BY RLUXGO FROM SEED " + this.jseed);
        } else {
            this.jseed = 314159265;
            this.diag("RANLUX INITIALIZED BY RLUXGO FROM DEFAULT SEED");
        }
        this.inseed = this.jseed;
        this.twom24 = 1.0f;
        for (i = 1; i <= 24; ++i) {
            this.twom24 *= 0.5f;
            int k = this.jseed / 53668;
            this.jseed = 40014 * (this.jseed - k * 53668) - k * 12211;
            if (this.jseed < 0) {
                this.jseed += 2147483563;
            }
            this.iseeds[i] = this.jseed % 0x1000000;
        }
        this.twom12 = this.twom24 * 4096.0f;
        for (i = 1; i <= 24; ++i) {
            this.seeds[i] = (float)this.iseeds[i] * this.twom24;
            this.next[i] = i - 1;
        }
        this.next[1] = 24;
        this.i24 = 24;
        this.j24 = 10;
        this.carry = 0.0f;
        if ((double)this.seeds[24] == 0.0) {
            this.carry = this.twom24;
        }
        this.kount = 0;
        this.mkount = 0;
    }

    private void diag(String s) {
        if (this.diagOn) {
            System.err.println(s);
        }
    }
}

