/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.generator;

import io.github.ngbsn.generator.ModelGenerator;
import io.github.ngbsn.model.Column;
import io.github.ngbsn.model.EmbeddableClass;
import io.github.ngbsn.model.ForeignKeyConstraint;
import io.github.ngbsn.model.Table;
import io.github.ngbsn.model.annotations.field.JoinColumnAnnotation;
import io.github.ngbsn.model.annotations.field.JoinColumnsAnnotation;
import io.github.ngbsn.model.annotations.field.ManyToOneAnnotation;
import io.github.ngbsn.model.annotations.field.MapsIdAnnotation;
import io.github.ngbsn.model.annotations.field.OneToManyAnnotation;
import io.github.ngbsn.util.Util;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.text.WordUtils;

public class UniDirectionalMappingsGenerator {
    private UniDirectionalMappingsGenerator() {
    }

    static void addBothSideUniDirectionalMappings(Table table, ForeignKeyConstraint foreignKeyConstraint) {
        Table referencedTable = ModelGenerator.getTablesMap().get(foreignKeyConstraint.getReferencedTableName().replaceAll("[\"']", ""));
        Column parentTableField = new Column();
        parentTableField.setFieldName(Util.convertSnakeCaseToCamelCase(referencedTable.getTableName(), false));
        parentTableField.setType(referencedTable.getClassName());
        parentTableField.getAnnotations().add(new ManyToOneAnnotation().toString());
        table.getColumns().add(parentTableField);
        Column childTableField = new Column();
        childTableField.setFieldName(Util.convertSnakeCaseToCamelCase(table.getTableName(), false) + "Set");
        childTableField.setType("Set<" + table.getClassName() + ">");
        childTableField.getAnnotations().add(OneToManyAnnotation.builder().mappedBy(parentTableField.getFieldName()).build().toString());
        referencedTable.getColumns().add(childTableField);
        Optional<EmbeddableClass> optionalEmbeddableId = table.getEmbeddableClasses().stream().filter(EmbeddableClass::isEmbeddedId).findFirst();
        EmbeddableClass embeddableId = optionalEmbeddableId.orElse(null);
        Set<Column> allPrimaryKeyColumns = UniDirectionalMappingsGenerator.getAllPrimaryKeys(table, embeddableId);
        if (foreignKeyConstraint.getColumns().size() > 1) {
            UniDirectionalMappingsGenerator.handleCompositeForeignKey(table, foreignKeyConstraint, parentTableField, embeddableId, allPrimaryKeyColumns);
        } else {
            UniDirectionalMappingsGenerator.handleSingleForeignKey(table, foreignKeyConstraint, parentTableField, allPrimaryKeyColumns);
        }
    }

    private static void handleSingleForeignKey(Table table, ForeignKeyConstraint foreignKeyConstraint, Column parentTableField, Set<Column> allPrimaryKeyColumns) {
        Optional<Column> optionalColumn = table.getColumns().stream().filter(column -> column.getColumnName() != null && column.getColumnName().equals(foreignKeyConstraint.getReferencedColumns().get(0))).findFirst();
        if (optionalColumn.isPresent()) {
            Column foreignKeyColumn = optionalColumn.get();
            Optional<Column> optionalColumnPrimaryForeign = allPrimaryKeyColumns.stream().filter(column -> column.getColumnName() != null && column.getColumnName().equals(foreignKeyColumn.getColumnName())).findFirst();
            optionalColumnPrimaryForeign.ifPresentOrElse(column -> parentTableField.getAnnotations().add(MapsIdAnnotation.builder().fieldName(column.getFieldName()).build().toString()), () -> optionalColumn.ifPresent(column -> table.getColumns().remove(column)));
        }
        parentTableField.getAnnotations().add(JoinColumnAnnotation.builder().name(foreignKeyConstraint.getReferencedColumns().get(0)).referencedColumnName(foreignKeyConstraint.getReferencedColumns().get(0)).build().toString());
    }

    private static void handleCompositeForeignKey(Table table, ForeignKeyConstraint foreignKeyConstraint, Column parentTableField, EmbeddableClass embeddableId, Set<Column> allPrimaryKeyColumns) {
        Set<Column> setOfForeignKeyColumns = UniDirectionalMappingsGenerator.setOfForeignKeys(table, foreignKeyConstraint);
        if (embeddableId != null && allPrimaryKeyColumns.containsAll(setOfForeignKeyColumns)) {
            UniDirectionalMappingsGenerator.handleSharedCompositePrimaryKey(table, parentTableField, embeddableId, setOfForeignKeyColumns);
        } else {
            setOfForeignKeyColumns.forEach(column -> table.getColumns().remove(column));
        }
        HashSet<JoinColumnAnnotation> joinColumns = new HashSet<JoinColumnAnnotation>();
        for (int i = 0; i < foreignKeyConstraint.getColumns().size(); ++i) {
            JoinColumnAnnotation joinColumnAnnotation = JoinColumnAnnotation.builder().name(foreignKeyConstraint.getColumns().get(i)).referencedColumnName(foreignKeyConstraint.getReferencedColumns().get(i)).build();
            joinColumns.add(joinColumnAnnotation);
        }
        parentTableField.getAnnotations().add(JoinColumnsAnnotation.builder().joinColumns(joinColumns).build().toString());
    }

    private static void handleSharedCompositePrimaryKey(Table table, Column parentTableField, EmbeddableClass embeddableId, Set<Column> setOfForeignKeyColumns) {
        EmbeddableClass foreignCompositeKeyEmbedded = new EmbeddableClass();
        String embeddableName = setOfForeignKeyColumns.stream().map(Column::getFieldName).collect(Collectors.joining());
        foreignCompositeKeyEmbedded.setClassName(WordUtils.capitalize((String)embeddableName));
        foreignCompositeKeyEmbedded.setFieldName(embeddableName);
        table.getEmbeddableClasses().add(foreignCompositeKeyEmbedded);
        setOfForeignKeyColumns.forEach(column -> {
            foreignCompositeKeyEmbedded.getColumns().add((Column)column);
            embeddableId.getColumns().remove(column);
        });
        Column foreignCompositeField = new Column();
        foreignCompositeField.setType(foreignCompositeKeyEmbedded.getClassName());
        foreignCompositeField.setFieldName(foreignCompositeKeyEmbedded.getFieldName());
        embeddableId.getColumns().add(foreignCompositeField);
        if (embeddableId.getFieldName() != null) {
            parentTableField.getAnnotations().add(MapsIdAnnotation.builder().fieldName(foreignCompositeField.getFieldName()).build().toString());
        }
    }

    private static Set<Column> setOfForeignKeys(Table table, ForeignKeyConstraint foreignKeyConstraint) {
        Stream allTableForeignKeyColumns = table.getColumns().stream();
        Stream allEmbeddedForeignKeyColumns = table.getEmbeddableClasses().stream().flatMap(embeddableClass -> embeddableClass.getColumns().stream());
        return Stream.concat(allTableForeignKeyColumns, allEmbeddedForeignKeyColumns).filter(column -> foreignKeyConstraint.getColumns().stream().anyMatch(s -> s.equals(column.getColumnName()))).collect(Collectors.toSet());
    }

    private static Set<Column> getAllPrimaryKeys(Table table, EmbeddableClass embeddableId) {
        if (embeddableId != null) {
            return embeddableId.getColumns().stream().filter(Column::isPrimaryKey).collect(Collectors.toSet());
        }
        return table.getColumns().stream().filter(Column::isPrimaryKey).collect(Collectors.toSet());
    }
}

