/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.model.annotations.field;

import io.github.ngbsn.model.annotations.Annotation;
import io.github.ngbsn.model.annotations.field.JoinColumnAnnotation;
import java.util.Set;
import java.util.stream.Collectors;

public class JoinTableAnnotation
implements Annotation {
    private String tableName;
    private Set<JoinColumnAnnotation> joinColumns;
    private Set<JoinColumnAnnotation> inverseJoinColumns;

    public String toString() {
        return "@JoinTable(name = \"" + this.tableName + "\", joinColumns = {" + this.joinColumns.stream().map(JoinColumnAnnotation::toString).collect(Collectors.joining("," + System.lineSeparator())) + "}, inverseJoinColumns = {" + this.inverseJoinColumns.stream().map(JoinColumnAnnotation::toString).collect(Collectors.joining("," + System.lineSeparator())) + "})";
    }

    JoinTableAnnotation(String tableName, Set<JoinColumnAnnotation> joinColumns, Set<JoinColumnAnnotation> inverseJoinColumns) {
        this.tableName = tableName;
        this.joinColumns = joinColumns;
        this.inverseJoinColumns = inverseJoinColumns;
    }

    public static JoinTableAnnotationBuilder builder() {
        return new JoinTableAnnotationBuilder();
    }

    public static class JoinTableAnnotationBuilder {
        private String tableName;
        private Set<JoinColumnAnnotation> joinColumns;
        private Set<JoinColumnAnnotation> inverseJoinColumns;

        JoinTableAnnotationBuilder() {
        }

        public JoinTableAnnotationBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public JoinTableAnnotationBuilder joinColumns(Set<JoinColumnAnnotation> joinColumns) {
            this.joinColumns = joinColumns;
            return this;
        }

        public JoinTableAnnotationBuilder inverseJoinColumns(Set<JoinColumnAnnotation> inverseJoinColumns) {
            this.inverseJoinColumns = inverseJoinColumns;
            return this;
        }

        public JoinTableAnnotation build() {
            return new JoinTableAnnotation(this.tableName, this.joinColumns, this.inverseJoinColumns);
        }

        public String toString() {
            return "JoinTableAnnotation.JoinTableAnnotationBuilder(tableName=" + this.tableName + ", joinColumns=" + this.joinColumns + ", inverseJoinColumns=" + this.inverseJoinColumns + ")";
        }
    }
}

