/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.generator;

import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import io.github.ngbsn.generator.ModelGenerator;
import io.github.ngbsn.model.Table;
import io.github.ngbsn.util.Util;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPACodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(JPACodeGenerator.class);
    private static final Logger logger = LoggerFactory.getLogger(JPACodeGenerator.class);

    public static void main(String[] args) throws TemplateException, IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[0]), StandardCharsets.UTF_8));){
            String sqlScript = bufferedReader.lines().collect(Collectors.joining("\n"));
            JPACodeGenerator.generateCode(sqlScript, args[1]);
        }
        catch (Exception e) {
            log.error("Error occurred while running the tool", (Throwable)e);
        }
    }

    public static void generateCode(String sqlScript, String packageName) throws IOException, TemplateException {
        logger.info("sql script {}", (Object)sqlScript);
        List<Table> tables = JPACodeGenerator.generateModels(sqlScript);
        JPACodeGenerator.processTemplate(tables, packageName);
    }

    private static List<Table> generateModels(String sqlScript) {
        return ModelGenerator.parse(sqlScript);
    }

    private static void processTemplate(List<Table> tables, String packageName) throws IOException, TemplateException {
        String source;
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_32);
        StringTemplateLoader templateLoader = new StringTemplateLoader();
        try (InputStream is = JPACodeGenerator.class.getClassLoader().getResourceAsStream("templates/entity.ftl");){
            assert (is != null);
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(is));){
                source = buffer.lines().collect(Collectors.joining("\n"));
            }
        }
        templateLoader.putTemplate("template", source);
        cfg.setTemplateLoader((TemplateLoader)templateLoader);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setFallbackOnNullLoopVariable(false);
        cfg.setSQLDateAndTimeTimeZone(TimeZone.getDefault());
        Template template = cfg.getTemplate("template");
        for (Table table : tables) {
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("table", table);
            root.put("package", packageName);
            ArrayList<String> imports = new ArrayList<String>();
            imports.add("java.util.*");
            imports.add("jakarta.persistence.*");
            imports.add("javax.validation.constraints.NotNull");
            imports.add("java.io.Serializable");
            imports.add("lombok.Getter");
            imports.add("lombok.Setter");
            imports.add("lombok.Builder");
            root.put("imports", imports);
            String dir = "target/generated-sources/sqlscript2jpa/src/main/java/" + Util.packageNameToFolderStructure(packageName);
            Files.createDirectories(Paths.get(dir, new String[0]), new FileAttribute[0]);
            FileOutputStream outputStream = new FileOutputStream(dir + table.getClassName() + ".java");
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream);
            template.process(root, (Writer)outputStreamWriter);
            outputStreamWriter.close();
        }
    }
}

