/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.maven;

import io.github.ngbsn.generator.JPACodeGenerator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="parse-schema")
public class JPACodeGenMojo
extends AbstractMojo {
    private static final Logger log = LoggerFactory.getLogger(JPACodeGenMojo.class);
    private static final Logger logger = LoggerFactory.getLogger(JPACodeGenMojo.class);
    @Parameter(property="sqlFilePath")
    private String sqlFilePath;
    @Parameter(property="packageName")
    private String packageName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        logger.info("Executing the goal parse-schema {} {}", (Object)this.sqlFilePath, (Object)this.packageName);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.sqlFilePath), StandardCharsets.UTF_8));){
            String sqlScript = bufferedReader.lines().collect(Collectors.joining("\n"));
            JPACodeGenerator.generateCode(sqlScript, this.packageName);
        }
        catch (Exception e) {
            log.error("Error occurred while running the plugin", (Throwable)e);
        }
    }
}

