/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.generator;

import io.github.ngbsn.generator.ModelGenerator;
import io.github.ngbsn.model.Column;
import io.github.ngbsn.model.ForeignKeyConstraint;
import io.github.ngbsn.model.Table;
import io.github.ngbsn.model.annotations.field.JoinColumnAnnotation;
import io.github.ngbsn.model.annotations.field.JoinTableAnnotation;
import io.github.ngbsn.model.annotations.field.ManyToManyAnnotation;
import io.github.ngbsn.util.Util;
import java.util.HashSet;
import java.util.List;

class BiDirectionalMappingsGenerator {
    private BiDirectionalMappingsGenerator() {
    }

    static void addBiDirectionalMappings(Table table, List<ForeignKeyConstraint> foreignKeyConstraintList) {
        Table table1 = ModelGenerator.getTablesMap().get(foreignKeyConstraintList.get(0).getReferencedTableName().replaceAll("[\"']", ""));
        Table table2 = ModelGenerator.getTablesMap().get(foreignKeyConstraintList.get(1).getReferencedTableName().replaceAll("[\"']", ""));
        Column column1 = new Column();
        column1.setFieldName(Util.convertSnakeCaseToCamelCase(table2.getTableName(), false));
        column1.setType(table2.getClassName());
        column1.getAnnotations().add(ManyToManyAnnotation.builder().build().toString());
        HashSet<JoinColumnAnnotation> joinColumnAnnotations = new HashSet<JoinColumnAnnotation>();
        for (String string : foreignKeyConstraintList.get(0).getColumns()) {
            joinColumnAnnotations.add(JoinColumnAnnotation.builder().name(string).build());
        }
        HashSet<JoinColumnAnnotation> joinInverseColumnAnnotations = new HashSet<JoinColumnAnnotation>();
        for (String column : foreignKeyConstraintList.get(1).getColumns()) {
            joinInverseColumnAnnotations.add(JoinColumnAnnotation.builder().name(column).build());
        }
        column1.getAnnotations().add(JoinTableAnnotation.builder().tableName(table.getTableName()).joinColumns(joinColumnAnnotations).inverseJoinColumns(joinInverseColumnAnnotations).build().toString());
        table1.getColumns().add(column1);
        Column column = new Column();
        column.setFieldName(Util.convertSnakeCaseToCamelCase(table1.getTableName(), false));
        column.setType(table1.getClassName());
        column.getAnnotations().add(ManyToManyAnnotation.builder().mappedBy(column1.getFieldName()).build().toString());
        table2.getColumns().add(column);
    }
}

