/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.generator;

import io.github.ngbsn.exception.SQLParsingException;
import io.github.ngbsn.generator.AssociationMappingsGenerator;
import io.github.ngbsn.model.Column;
import io.github.ngbsn.model.EmbeddableClass;
import io.github.ngbsn.model.ForeignKeyConstraint;
import io.github.ngbsn.model.Table;
import io.github.ngbsn.model.TableEnum;
import io.github.ngbsn.model.annotations.entity.EntityAnnotation;
import io.github.ngbsn.model.annotations.entity.TableAnnotation;
import io.github.ngbsn.model.annotations.field.ColumnAnnotation;
import io.github.ngbsn.model.annotations.field.EnumeratedAnnotation;
import io.github.ngbsn.model.annotations.field.NotNullAnnotation;
import io.github.ngbsn.util.SQLTypeToJpaTypeMapping;
import io.github.ngbsn.util.Util;
import jakarta.persistence.EnumType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.ForeignKeyIndex;
import net.sf.jsqlparser.statement.create.table.Index;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelGenerator {
    public static final String REGEX_ALL_QUOTES = "[\"']";
    private static final Logger logger = LoggerFactory.getLogger(ModelGenerator.class);
    private static final Map<String, Table> tablesMap = new HashMap<String, Table>();

    private ModelGenerator() {
    }

    public static void clearTablesMap() {
        tablesMap.clear();
    }

    public static Map<String, Table> getTablesMap() {
        return tablesMap;
    }

    static List<Table> parse(String sqlScript) throws SQLParsingException {
        String extractedStatementWithoutDefaultConstraint = null;
        try {
            String[] extractedStatementsArray = sqlScript.split(";");
            List<String> extractedStatementsList = Arrays.stream(extractedStatementsArray).filter(s -> {
                String regexCreateTable = "CREATE\\s+TABLE";
                Pattern patternCreateTable = Pattern.compile(regexCreateTable);
                Matcher matcherCreateTable = patternCreateTable.matcher((CharSequence)s);
                String regexAlterTable = "ALTER\\s+TABLE";
                Pattern patternAlterTable = Pattern.compile(regexAlterTable);
                Matcher matcherAlterTable = patternAlterTable.matcher((CharSequence)s);
                return matcherCreateTable.find() || matcherAlterTable.find();
            }).toList();
            ArrayList<Statement> statements = new ArrayList<Statement>();
            for (String extractedStatement : extractedStatementsList) {
                extractedStatementWithoutDefaultConstraint = Util.removeDefaultConstraint(extractedStatement);
                statements.add(CCJSqlParserUtil.parse((String)extractedStatementWithoutDefaultConstraint));
            }
            ModelGenerator.processCreateTableStatements(statements);
            ModelGenerator.processAlterTableStatements(statements);
            AssociationMappingsGenerator.generateMappings();
            return tablesMap.values().stream().toList();
        }
        catch (JSQLParserException e) {
            logger.error("Error occurred {}", (Object)e.getMessage());
            logger.error("Statement having issue with parsing {}", extractedStatementWithoutDefaultConstraint);
            throw new SQLParsingException("Statement having issue with parsing");
        }
    }

    private static void processCreateTableStatements(List<Statement> statements) {
        statements.forEach(statement -> {
            if (statement instanceof CreateTable) {
                CreateTable parsedTable = (CreateTable)statement;
                Table table = new Table();
                table.setTableName(parsedTable.getTable().getName().replaceAll(REGEX_ALL_QUOTES, ""));
                tablesMap.put(table.getTableName(), table);
                Object className = Util.convertSnakeCaseToCamelCase(table.getTableName(), true);
                className = SourceVersion.isKeyword((CharSequence)className) ? (String)className + "Entity" : className;
                table.setClassName((String)className);
                HashSet<String> tableAnnotations = new HashSet<String>();
                table.setAnnotations(tableAnnotations);
                tableAnnotations.add(new EntityAnnotation().toString());
                tableAnnotations.add(TableAnnotation.builder().tableName(table.getTableName()).build().toString());
                HashSet<Column> columns = new HashSet<Column>();
                table.setColumns(columns);
                ModelGenerator.extractColumns(table, parsedTable, columns);
                if (parsedTable.getIndexes() != null) {
                    Optional<Index> optionalIndex = parsedTable.getIndexes().stream().filter(index -> index.getType() != null && index.getType().equals("PRIMARY KEY")).findFirst();
                    ModelGenerator.extractPrimaryKeys(optionalIndex.orElse(null), table);
                    List<Index> foreignKeyIndexes = parsedTable.getIndexes().stream().filter(ForeignKeyIndex.class::isInstance).toList();
                    ModelGenerator.extractForeignKeys(foreignKeyIndexes, table);
                }
            }
        });
    }

    private static void processAlterTableStatements(List<Statement> statements) {
        statements.forEach(statement -> {
            if (statement instanceof Alter) {
                Alter alterTable = (Alter)statement;
                Table table = tablesMap.get(alterTable.getTable().getName().replaceAll(REGEX_ALL_QUOTES, ""));
                ArrayList<Index> foreignKeyIndexes = new ArrayList<Index>();
                alterTable.getAlterExpressions().forEach(alterExpression -> {
                    if (alterExpression.getIndex() instanceof ForeignKeyIndex) {
                        foreignKeyIndexes.add(alterExpression.getIndex());
                    } else if (alterExpression.getIndex() != null && alterExpression.getIndex().getType().equals("PRIMARY KEY")) {
                        ModelGenerator.extractPrimaryKeys(alterExpression.getIndex(), table);
                    }
                });
                ModelGenerator.extractForeignKeys(foreignKeyIndexes, table);
            }
        });
    }

    private static void extractForeignKeys(List<Index> foreignKeyIndexes, Table table) {
        if (!foreignKeyIndexes.isEmpty()) {
            foreignKeyIndexes.forEach(index -> {
                if (index instanceof ForeignKeyIndex) {
                    ForeignKeyIndex foreignKeyIndex = (ForeignKeyIndex)index;
                    ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint();
                    foreignKeyConstraint.setColumns(foreignKeyIndex.getColumnsNames().stream().map(s -> s.replaceAll(REGEX_ALL_QUOTES, "")).toList());
                    foreignKeyConstraint.setReferencedColumns(foreignKeyIndex.getReferencedColumnNames().stream().map(s -> s.replaceAll(REGEX_ALL_QUOTES, "")).toList());
                    foreignKeyConstraint.setReferencedTableName(foreignKeyIndex.getTable().getName().replaceAll(REGEX_ALL_QUOTES, ""));
                    table.getForeignKeyConstraints().add(foreignKeyConstraint);
                }
            });
        }
    }

    private static void extractPrimaryKeys(Index primaryKeyIndex, Table table) {
        List columnParamsList;
        List list = columnParamsList = primaryKeyIndex != null ? primaryKeyIndex.getColumns() : null;
        if (columnParamsList != null) {
            Set<Column> primaryKeyColumns = table.getColumns().stream().filter(column -> columnParamsList.stream().anyMatch(columnParams -> columnParams.getColumnName().replaceAll(REGEX_ALL_QUOTES, "").equals(column.getColumnName()))).collect(Collectors.toSet());
            if (columnParamsList.size() > 1) {
                table.setNumOfPrimaryKeyColumns(columnParamsList.size());
                EmbeddableClass embeddedId = new EmbeddableClass();
                embeddedId.setClassName(table.getClassName() + "PK");
                embeddedId.setFieldName(Util.convertSnakeCaseToCamelCase(table.getTableName(), false) + "PK");
                embeddedId.setEmbeddedId(true);
                table.getEmbeddableClasses().add(embeddedId);
                primaryKeyColumns.forEach(column -> {
                    table.getColumns().remove(column);
                    embeddedId.getColumns().add((Column)column);
                });
            }
            primaryKeyColumns.forEach(column -> column.setPrimaryKey(true));
        }
    }

    private static void extractColumns(Table table, CreateTable parsedTable, Set<Column> columns) {
        parsedTable.getColumnDefinitions().forEach(columnDefinition -> {
            String constraints;
            Column column = new Column();
            columns.add(column);
            HashSet<String> columnAnnotations = new HashSet<String>();
            column.setAnnotations(columnAnnotations);
            column.setColumnName(columnDefinition.getColumnName().replaceAll(REGEX_ALL_QUOTES, ""));
            columnAnnotations.add(ColumnAnnotation.builder().columnName(column.getColumnName()).build().toString());
            String fieldName = Util.convertSnakeCaseToCamelCase(column.getColumnName(), false);
            fieldName = SourceVersion.isKeyword(fieldName) ? fieldName + table.getClassName() : fieldName;
            column.setFieldName(fieldName);
            if (columnDefinition.getColDataType().getDataType().equals("ENUM")) {
                TableEnum tableEnum = new TableEnum();
                table.getTableEnums().add(tableEnum);
                tableEnum.setEnumName(WordUtils.capitalize((String)column.getColumnName()) + "Enum");
                List<String> values = tableEnum.getValues();
                for (String s : columnDefinition.getColDataType().getArgumentsStringList()) {
                    values.add(s.replaceAll(REGEX_ALL_QUOTES, ""));
                }
                column.setType(tableEnum.getEnumName());
                columnAnnotations.add(EnumeratedAnnotation.builder().value(EnumType.STRING).build().toString());
            } else {
                String mappedJavaType = SQLTypeToJpaTypeMapping.getTypeMapping(columnDefinition.getColDataType().getDataType());
                column.setType(Objects.requireNonNullElse(mappedJavaType, "Object"));
            }
            if (columnDefinition.getColumnSpecs() != null && (constraints = String.join((CharSequence)" ", columnDefinition.getColumnSpecs())).contains("NOT NULL")) {
                columnAnnotations.add(NotNullAnnotation.builder().build().toString());
            }
        });
    }
}

