/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.generator.associations;

import io.github.ngbsn.generator.associations.ManyToManyMappingsGenerator;
import io.github.ngbsn.generator.associations.OneToManyMappingsGenerator;
import io.github.ngbsn.generator.models.ModelGenerator;
import io.github.ngbsn.model.Column;
import io.github.ngbsn.model.ForeignKeyConstraint;
import io.github.ngbsn.model.Table;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AssociationMappingsGenerator {
    private AssociationMappingsGenerator() {
    }

    public static void generateMappings() {
        Iterator<Map.Entry<String, Table>> it = ModelGenerator.getTablesMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Table> item = it.next();
            Table table = item.getValue();
            List<ForeignKeyConstraint> foreignKeyConstraintList = table.getForeignKeyConstraints();
            if (foreignKeyConstraintList.size() == 1) {
                OneToManyMappingsGenerator.addBiDirectionalMappings(table, foreignKeyConstraintList.get(0));
                continue;
            }
            List foreignKeyColumns = foreignKeyConstraintList.stream().flatMap(foreignKeyConstraint -> foreignKeyConstraint.getColumns().stream()).toList();
            Optional<Column> optionalKey = table.getColumns().stream().filter(column -> !foreignKeyColumns.contains(column.getColumnName())).findAny();
            if (optionalKey.isEmpty() && foreignKeyConstraintList.size() == 2) {
                it.remove();
                ManyToManyMappingsGenerator.addManyToManyMappings(table, foreignKeyConstraintList);
                continue;
            }
            foreignKeyConstraintList.forEach(foreignKeyConstraint -> OneToManyMappingsGenerator.addBiDirectionalMappings(table, foreignKeyConstraint));
        }
    }
}

