/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.generator.associations;

import io.github.ngbsn.generator.models.ModelGenerator;
import io.github.ngbsn.model.Column;
import io.github.ngbsn.model.ForeignKeyConstraint;
import io.github.ngbsn.model.Table;
import io.github.ngbsn.model.annotations.field.JoinColumnAnnotation;
import io.github.ngbsn.model.annotations.field.JoinTableAnnotation;
import io.github.ngbsn.model.annotations.field.ManyToManyAnnotation;
import io.github.ngbsn.util.Util;
import java.util.ArrayList;
import java.util.List;

public class ManyToManyMappingsGenerator {
    private ManyToManyMappingsGenerator() {
    }

    public static void addManyToManyMappings(Table table, List<ForeignKeyConstraint> foreignKeyConstraintList) {
        Table table1 = ModelGenerator.getTablesMap().get(foreignKeyConstraintList.get(0).getReferencedTableName().replaceAll("[\"']", ""));
        Table table2 = ModelGenerator.getTablesMap().get(foreignKeyConstraintList.get(1).getReferencedTableName().replaceAll("[\"']", ""));
        Column column1 = new Column();
        column1.setFieldName(Util.convertSnakeCaseToCamelCase(table2.getTableName(), false));
        column1.setType("Set<" + table2.getClassName() + ">");
        column1.getAnnotations().add(ManyToManyAnnotation.builder().build().toString());
        ArrayList<JoinColumnAnnotation> joinColumnAnnotations = new ArrayList<JoinColumnAnnotation>();
        for (String string : foreignKeyConstraintList.get(0).getColumns()) {
            joinColumnAnnotations.add(JoinColumnAnnotation.builder().name(string).build());
        }
        ArrayList<JoinColumnAnnotation> joinInverseColumnAnnotations = new ArrayList<JoinColumnAnnotation>();
        for (String column : foreignKeyConstraintList.get(1).getColumns()) {
            joinInverseColumnAnnotations.add(JoinColumnAnnotation.builder().name(column).build());
        }
        column1.getAnnotations().add(JoinTableAnnotation.builder().tableName(table.getTableName()).joinColumns(joinColumnAnnotations).inverseJoinColumns(joinInverseColumnAnnotations).build().toString());
        table1.getColumns().add(column1);
        Column column = new Column();
        column.setFieldName(Util.convertSnakeCaseToCamelCase(table1.getTableName(), false));
        column.setType("Set<" + table1.getClassName() + ">");
        column.getAnnotations().add(ManyToManyAnnotation.builder().mappedBy(column1.getFieldName()).build().toString());
        table2.getColumns().add(column);
    }
}

