/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.generator.associations;

import io.github.ngbsn.generator.models.ModelGenerator;
import io.github.ngbsn.model.Column;
import io.github.ngbsn.model.EmbeddableClass;
import io.github.ngbsn.model.ForeignKeyConstraint;
import io.github.ngbsn.model.Table;
import io.github.ngbsn.model.annotations.field.ColumnAnnotation;
import io.github.ngbsn.model.annotations.field.JoinColumnAnnotation;
import io.github.ngbsn.model.annotations.field.JoinColumnsAnnotation;
import io.github.ngbsn.model.annotations.field.ManyToOneAnnotation;
import io.github.ngbsn.model.annotations.field.MapsIdAnnotation;
import io.github.ngbsn.model.annotations.field.OneToManyAnnotation;
import io.github.ngbsn.util.Util;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class OneToManyMappingsGenerator {
    private OneToManyMappingsGenerator() {
    }

    public static void addBiDirectionalMappings(Table table, ForeignKeyConstraint foreignKeyConstraint) {
        Table parentTable = ModelGenerator.getTablesMap().get(foreignKeyConstraint.getReferencedTableName().replaceAll("[\"']", ""));
        Column parentTableField = new Column();
        parentTableField.setFieldName(Util.convertSnakeCaseToCamelCase(String.join((CharSequence)"", foreignKeyConstraint.getColumns()), false) + Util.convertSnakeCaseToCamelCase(parentTable.getTableName(), true));
        parentTableField.setType(parentTable.getClassName());
        parentTableField.getAnnotations().add(new ManyToOneAnnotation().toString());
        table.getColumns().add(parentTableField);
        Column childTableField = new Column();
        childTableField.setFieldName(Util.convertSnakeCaseToCamelCase(String.join((CharSequence)"", foreignKeyConstraint.getColumns()), false) + Util.convertSnakeCaseToCamelCase(table.getTableName(), true) + "Set");
        childTableField.setType("Set<" + table.getClassName() + ">");
        childTableField.getAnnotations().add(OneToManyAnnotation.builder().mappedBy(parentTableField.getFieldName()).build().toString());
        parentTable.getColumns().add(childTableField);
        EmbeddableClass embeddableId = table.getEmbeddedId();
        List<Column> allPrimaryKeyColumns = OneToManyMappingsGenerator.getAllPrimaryKeys(table, embeddableId);
        if (foreignKeyConstraint.getColumns().size() > 1) {
            OneToManyMappingsGenerator.handleCompositeForeignKey(table, parentTable, foreignKeyConstraint, parentTableField, embeddableId, allPrimaryKeyColumns);
        } else {
            OneToManyMappingsGenerator.handleSingleForeignKey(table, foreignKeyConstraint, parentTableField, allPrimaryKeyColumns);
        }
    }

    private static void handleSingleForeignKey(Table table, ForeignKeyConstraint foreignKeyConstraint, Column parentTableField, List<Column> allPrimaryKeyColumns) {
        Column foreignKeyColumn;
        List<Column> listOfForeignKeyColumns = OneToManyMappingsGenerator.listOfForeignKeys(table, foreignKeyConstraint);
        Column column2 = foreignKeyColumn = !listOfForeignKeyColumns.isEmpty() ? listOfForeignKeyColumns.get(0) : null;
        if (foreignKeyColumn == null) {
            throw new UnsupportedOperationException();
        }
        Optional<Column> optionalColumnPrimaryForeign = allPrimaryKeyColumns.stream().filter(column -> column.getColumnName() != null && column.getColumnName().equals(foreignKeyColumn.getColumnName())).findFirst();
        optionalColumnPrimaryForeign.ifPresentOrElse(column -> {
            column.setSharedPrimaryKey(true);
            parentTableField.getAnnotations().add(MapsIdAnnotation.builder().fieldName(column.getFieldName()).build().toString());
            column.getAnnotations().removeIf(s -> s.contains("@Column"));
            column.getAnnotations().add(ColumnAnnotation.builder().columnName(column.getColumnName()).updatable(false).insertable(false).build().toString());
        }, () -> table.getColumns().remove(foreignKeyColumn));
        parentTableField.getAnnotations().add(JoinColumnAnnotation.builder().name(foreignKeyConstraint.getColumns().get(0)).referencedColumnName(foreignKeyConstraint.getReferencedColumns().get(0)).build().toString());
    }

    private static void handleCompositeForeignKey(Table table, Table parentTable, ForeignKeyConstraint foreignKeyConstraint, Column parentTableField, EmbeddableClass embeddableId, List<Column> allPrimaryKeyColumns) {
        List<Column> listOfForeignKeyColumns = OneToManyMappingsGenerator.listOfForeignKeys(table, foreignKeyConstraint);
        if (embeddableId != null && new HashSet<Column>(allPrimaryKeyColumns).equals(new HashSet<Column>(listOfForeignKeyColumns))) {
            OneToManyMappingsGenerator.handleCompositeForeignKeySameAsCompositePrimaryKey(table, parentTable, parentTableField);
        } else if (embeddableId != null && new HashSet<Column>(allPrimaryKeyColumns).containsAll(listOfForeignKeyColumns)) {
            OneToManyMappingsGenerator.handleCompositeForeignKeyInsideCompositePrimaryKey(parentTable, parentTableField, embeddableId, listOfForeignKeyColumns);
        } else {
            listOfForeignKeyColumns.forEach(column -> table.getColumns().remove(column));
        }
        ArrayList<JoinColumnAnnotation> joinColumns = new ArrayList<JoinColumnAnnotation>();
        for (int i = 0; i < foreignKeyConstraint.getColumns().size(); ++i) {
            JoinColumnAnnotation joinColumnAnnotation = JoinColumnAnnotation.builder().name(foreignKeyConstraint.getColumns().get(i)).referencedColumnName(foreignKeyConstraint.getReferencedColumns().get(i)).build();
            joinColumns.add(joinColumnAnnotation);
        }
        parentTableField.getAnnotations().add(JoinColumnsAnnotation.builder().joinColumns(joinColumns).build().toString());
    }

    private static void handleCompositeForeignKeySameAsCompositePrimaryKey(Table table, Table parentTable, Column parentTableField) {
        EmbeddableClass parentEmbeddedId = parentTable.getEmbeddedId();
        Column parentEmbeddedIdColumn = new Column();
        parentEmbeddedIdColumn.setType(parentTable.getClassName() + "." + parentEmbeddedId.getClassName());
        parentEmbeddedIdColumn.setFieldName(parentEmbeddedId.getFieldName());
        parentEmbeddedIdColumn.setEmbeddedId(true);
        table.getColumns().add(parentEmbeddedIdColumn);
        table.setEmbeddedId(null);
        parentTableField.getAnnotations().add(MapsIdAnnotation.builder().fieldName(parentEmbeddedIdColumn.getFieldName()).build().toString());
    }

    private static void handleCompositeForeignKeyInsideCompositePrimaryKey(Table parentTable, Column parentTableField, EmbeddableClass embeddableId, List<Column> listOfForeignKeyColumns) {
        listOfForeignKeyColumns.forEach(column -> embeddableId.getColumns().remove(column));
        EmbeddableClass parentEmbeddedId = parentTable.getEmbeddedId();
        Column parentEmbeddedIdColumn = new Column();
        parentEmbeddedIdColumn.setType(parentTable.getClassName() + "." + parentEmbeddedId.getClassName());
        parentEmbeddedIdColumn.setFieldName(parentEmbeddedId.getFieldName());
        embeddableId.getColumns().add(parentEmbeddedIdColumn);
        parentTableField.getAnnotations().add(MapsIdAnnotation.builder().fieldName(parentEmbeddedIdColumn.getFieldName()).build().toString());
    }

    private static List<Column> listOfForeignKeys(Table table, ForeignKeyConstraint foreignKeyConstraint) {
        Stream allColumnsFromTable = table.getColumns().stream();
        Stream allColumnsFromEmbeddedId = table.getEmbeddedId() != null ? table.getEmbeddedId().getColumns().stream() : Stream.empty();
        return Stream.concat(allColumnsFromTable, allColumnsFromEmbeddedId).filter(column -> foreignKeyConstraint.getColumns().stream().anyMatch(s -> s.equals(column.getColumnName()))).toList();
    }

    private static List<Column> getAllPrimaryKeys(Table table, EmbeddableClass embeddableId) {
        if (embeddableId != null) {
            return embeddableId.getColumns().stream().filter(Column::isPrimaryKey).toList();
        }
        return table.getColumns().stream().filter(Column::isPrimaryKey).toList();
    }
}

