/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.model.annotations.field;

import io.github.ngbsn.model.annotations.Annotation;

public class ColumnAnnotation
implements Annotation {
    private String columnName;
    private Boolean insertable;
    private Boolean updatable;

    public String toString() {
        String nameAttr = this.columnName != null ? "name = \"" + this.columnName + "\"" : "";
        String insertableAttr = this.insertable != null ? ", insertable = " + this.insertable : "";
        String updatableAttr = this.updatable != null ? ", updatable = " + this.updatable : "";
        return "@Column(" + nameAttr + insertableAttr + updatableAttr + ")";
    }

    ColumnAnnotation(String columnName, Boolean insertable, Boolean updatable) {
        this.columnName = columnName;
        this.insertable = insertable;
        this.updatable = updatable;
    }

    public static ColumnAnnotationBuilder builder() {
        return new ColumnAnnotationBuilder();
    }

    public static class ColumnAnnotationBuilder {
        private String columnName;
        private Boolean insertable;
        private Boolean updatable;

        ColumnAnnotationBuilder() {
        }

        public ColumnAnnotationBuilder columnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public ColumnAnnotationBuilder insertable(Boolean insertable) {
            this.insertable = insertable;
            return this;
        }

        public ColumnAnnotationBuilder updatable(Boolean updatable) {
            this.updatable = updatable;
            return this;
        }

        public ColumnAnnotation build() {
            return new ColumnAnnotation(this.columnName, this.insertable, this.updatable);
        }

        public String toString() {
            return "ColumnAnnotation.ColumnAnnotationBuilder(columnName=" + this.columnName + ", insertable=" + this.insertable + ", updatable=" + this.updatable + ")";
        }
    }
}

