/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngbsn.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.text.CaseUtils;
import org.apache.commons.text.WordUtils;

public class Util {
    private Util() {
    }

    public static String packageNameToFolderStructure(String packageName) {
        return packageName.replace(".", "/") + "/";
    }

    public static String convertSnakeCaseToCamelCase(String word, boolean captializeFirstChar) {
        word = captializeFirstChar ? WordUtils.capitalize((String)word) : WordUtils.uncapitalize((String)word);
        return word.contains("_") ? CaseUtils.toCamelCase((String)word, (boolean)captializeFirstChar, (char[])new char[]{'_'}) : word;
    }

    public static String removeDefaultConstraint(String extractedStatement) {
        int endIndex;
        int startIndex;
        Pattern patternParentheses = Pattern.compile("DEFAULT\\s+\\(", 2);
        Pattern patternSingleQuote = Pattern.compile("DEFAULT\\s+'", 2);
        Pattern patternDoubleQuote = Pattern.compile("DEFAULT\\s+\"", 2);
        Matcher matcherParentheses = patternParentheses.matcher(extractedStatement);
        Matcher matcherSingleQuote = patternSingleQuote.matcher(extractedStatement);
        Matcher matcherDoubleQuote = patternDoubleQuote.matcher(extractedStatement);
        ArrayList<String> stringsToBeRemoved = new ArrayList<String>();
        while (matcherParentheses.find()) {
            int index = matcherParentheses.start();
            ArrayDeque<Character> stack = new ArrayDeque<Character>();
            int startIndexOfOpenParentheses = index;
            boolean beginProcess = true;
            while (!stack.isEmpty() || beginProcess) {
                if (extractedStatement.charAt(index) == '(') {
                    stack.add(Character.valueOf(extractedStatement.charAt(index)));
                    beginProcess = false;
                } else if (extractedStatement.charAt(index) == ')') {
                    stack.pop();
                }
                ++index;
            }
            int endIndexOfOpenParentheses = index;
            stringsToBeRemoved.add(extractedStatement.substring(startIndexOfOpenParentheses, endIndexOfOpenParentheses));
        }
        while (matcherSingleQuote.find()) {
            startIndex = matcherSingleQuote.start();
            int beginIndex = matcherSingleQuote.end();
            endIndex = extractedStatement.indexOf("'", beginIndex);
            stringsToBeRemoved.add(extractedStatement.substring(startIndex, endIndex + 1));
        }
        while (matcherDoubleQuote.find()) {
            startIndex = matcherDoubleQuote.start();
            int beginIndex = matcherDoubleQuote.end();
            endIndex = extractedStatement.indexOf("\"", beginIndex);
            stringsToBeRemoved.add(extractedStatement.substring(startIndex, endIndex + 1));
        }
        for (String s : stringsToBeRemoved) {
            extractedStatement = extractedStatement.replace(s, "");
        }
        return extractedStatement;
    }
}

