/*
 * Decompiled with CFR 0.152.
 */
package oit.utilities;

import java.time.Duration;
import java.util.function.Function;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.Wait;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Actions {
    private static WebDriver driver;
    public static WebElement element;
    public static Wait<WebDriver> wait;
    public static JavascriptExecutor executor;

    public Actions(WebDriver driver) {
        Actions.driver = driver;
        wait = new WebDriverWait(driver, Duration.ofSeconds(10L));
        executor = (JavascriptExecutor)driver;
    }

    public WebElement checkAvailabilityOf(By locator) throws Exception {
        try {
            wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
        }
        catch (Exception e) {
            System.out.println("Element " + locator.toString() + " is not present on the current DOM");
        }
        try {
            wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)locator));
        }
        catch (Exception e) {
            System.out.println("Element " + locator.toString() + " is not visible on the current DOM");
        }
        element = (WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)locator));
        if (element.isEnabled()) {
            return element;
        }
        throw new Exception("Element " + locator.getClass().getName() + " is not interactive & visible ");
    }

    public void typeInTextField(By locator, String string) {
        try {
            WebElement element = this.checkAvailabilityOf(locator);
            element.clear();
            element.sendKeys(new CharSequence[]{string});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void typeInField(By locator, String string) {
        try {
            WebElement element = this.checkAvailabilityOf(locator);
            executor.executeScript("arguments[0].value='" + string + "';", new Object[]{element});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void typeInteger(By locator, Integer number) {
        try {
            WebElement element = this.checkAvailabilityOf(locator);
            executor.executeScript("arguments[0].value='" + number + "';", new Object[]{element});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void appendText(By locator, String string) {
        try {
            driver.findElement(locator).sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, Keys.HOME}) + string});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void imageSendKeys(By locator, String string) {
        try {
            driver.findElement(locator).sendKeys(new CharSequence[]{string});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String imageSendKeys_AlertHandling(By locator, String string) {
        String alertText = "";
        try {
            driver.findElement(locator).sendKeys(new CharSequence[]{string});
            Alert alert = driver.switchTo().alert();
            alertText = alert.getText();
            alert.accept();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return alertText;
    }

    public void typeInTextFieldAndEnter(By locator, String string) {
        try {
            WebElement element = this.checkAvailabilityOf(locator);
            element.clear();
            element.sendKeys(new CharSequence[]{string});
            element.sendKeys(new CharSequence[]{Keys.ENTER});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clickAction(By locator) {
        try {
            WebElement element = this.checkAvailabilityOf(locator);
            executor.executeScript("arguments[0].click();", new Object[]{element});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doubleClickAction(By locator) {
        try {
            WebElement ele = driver.findElement(locator);
            org.openqa.selenium.interactions.Actions actions = new org.openqa.selenium.interactions.Actions(driver).doubleClick(ele);
            actions.build().perform();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clickActionManyTimes(By locator) {
        int counter = 0;
        try {
            WebElement element = this.checkAvailabilityOf(locator);
            do {
                executor.executeScript("arguments[0].click();", new Object[]{element});
            } while (++counter != 5);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clickJS(By locator) {
        try {
            executor.executeScript("arguments[0].click();", new Object[]{driver.findElement(locator)});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clickJS2(String id) {
        try {
            executor.executeScript("var clickEvent = document.createEvent ('MouseEvents');clickEvent.initEvent ('mousedown', true, true);document.getElementById('" + id + "').dispatchEvent(clickEvent);", new Object[0]);
            executor.executeScript("const ke = new KeyboardEvent('keydown', {bubbles: true, cancelable: true, keyCode: 13});document.getElementById('" + id + "').dispatchEvent(ke);", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void click(By locator) {
        try {
            driver.findElement(locator).click();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dropDownByText(By locator, String value) {
        try {
            WebElement element = this.checkAvailabilityOf(locator);
            Select select = new Select(element);
            select.selectByVisibleText(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dropDownByIndex(By locator, int value) {
        try {
            WebElement element = this.checkAvailabilityOf(locator);
            Select select = new Select(element);
            select.selectByIndex(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dropDownByValue(By locator, String value) {
        try {
            WebElement element = this.checkAvailabilityOf(locator);
            Select select = new Select(element);
            select.selectByValue(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void switchToFrame(By locator) {
        try {
            WebElement element = this.checkAvailabilityOf(locator);
            driver.switchTo().frame(element);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void scrollToElement(By locator) throws InterruptedException {
        WebElement element = driver.findElement(locator);
        ((JavascriptExecutor)driver).executeScript("arguments[0].scrollIntoView(true);", new Object[]{element});
        Thread.sleep(500L);
    }
}

