/*
 * Decompiled with CFR 0.152.
 */
package oit.utilities;

import java.util.Set;
import org.openqa.selenium.WebDriver;

public class SwitchToNewWindow {
    public static WebDriver driver;

    public SwitchToNewWindow(WebDriver driver) {
        SwitchToNewWindow.driver = driver;
    }

    public void switchToChildWindow() {
        String parentWindow = driver.getWindowHandle();
        Set childWindows = driver.getWindowHandles();
        for (String newWindow : childWindows) {
            if (newWindow.equalsIgnoreCase(parentWindow)) continue;
            driver.switchTo().window(newWindow);
        }
    }

    public void backToParentWindow() {
        String childWindows = driver.getWindowHandle();
        Set parentWindow = driver.getWindowHandles();
        for (String newWindow : parentWindow) {
            if (newWindow.equalsIgnoreCase(childWindows)) continue;
            driver.switchTo().window(newWindow);
        }
    }

    public void closeChildBackToParent() throws InterruptedException {
        try {
            String childWindow = driver.getWindowHandle();
            Set windows = driver.getWindowHandles();
            for (String newWindow : windows) {
                if (newWindow.equalsIgnoreCase(childWindow)) continue;
                driver.switchTo().window(childWindow).close();
                driver.switchTo().window(newWindow);
            }
        }
        catch (Exception e) {
            driver.navigate().refresh();
        }
    }
}

