/*
 * Decompiled with CFR 0.152.
 */
package oit.utilities;

import java.time.Duration;
import java.util.function.Function;
import oit.utilities.Actions;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Wait;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Waits {
    Actions actions;
    private WebDriver driver;
    public static Wait<WebDriver> wait;
    public static Wait<WebDriver> fWait;

    public Waits(WebDriver driver) {
        this.driver = driver;
        wait = new WebDriverWait(driver, Duration.ofSeconds(35L));
        this.actions = new Actions(driver);
    }

    public void waitForJSandJQueryToLoad() {
        Boolean readyStateComplete = false;
        while (!readyStateComplete.booleanValue()) {
            JavascriptExecutor executor = (JavascriptExecutor)this.driver;
            executor.executeScript("window.scrollTo(0, document.body.offsetHeight)", new Object[0]);
            System.out.println((String)executor.executeScript("return document.readyState", new Object[0]));
            readyStateComplete = ((String)executor.executeScript("return document.readyState", new Object[0])).equals("complete");
        }
    }

    public void waitForTextAppears(By locator, String textToBePresent) {
        wait.until((Function)ExpectedConditions.textToBePresentInElementLocated((By)locator, (String)textToBePresent));
    }

    public void waitForTextNotAppears(By locator, String textToBePresent) {
        wait.until((Function)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.textToBePresentInElementLocated((By)locator, (String)textToBePresent)));
    }

    public void waitForElementAppearsAndPresence(By locator) {
        wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)locator));
        wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
    }

    public void waitForElementAppears(By locator) {
        wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)locator));
    }

    public void waitForElementNOTAppears(By locator) {
        wait.until((Function)ExpectedConditions.invisibilityOfElementLocated((By)locator));
    }

    public void waitForElementToBeClickable(By locator) {
        wait.until((Function)ExpectedConditions.elementToBeClickable((By)locator));
    }

    public void scrollDown() {
        JavascriptExecutor executor = (JavascriptExecutor)this.driver;
        executor.executeScript("window.scrollTo(0, document.body.offsetHeight)", new Object[0]);
    }

    public void fluentWaitForVisibility(int numberOfAttempts, int timePeriod, String elementToBeVisible) throws Exception {
        fWait = new WebDriverWait(this.driver, Duration.ofSeconds(timePeriod));
        for (int i = 1; i <= numberOfAttempts; ++i) {
            try {
                System.out.println("Attempt number " + i + " With time period " + timePeriod + " seconds to for the element to be visible");
                fWait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)elementToBeVisible)));
                break;
            }
            catch (Exception e) {
                if (i == numberOfAttempts) {
                    throw new Exception("Couldn't find element");
                }
                this.driver.navigate().refresh();
                this.waitForJSandJQueryToLoad();
                continue;
            }
        }
    }

    public void fluentWaitForPresence(int numberOfAttempts, int timePeriod, String elementToBeVisible) throws Exception {
        fWait = new WebDriverWait(this.driver, Duration.ofSeconds(timePeriod));
        this.driver.navigate().refresh();
        for (int i = 1; i <= numberOfAttempts; ++i) {
            try {
                System.out.println("Attempt number " + i + " With time period " + timePeriod + " seconds for the element to be present");
                fWait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)elementToBeVisible)));
                break;
            }
            catch (Exception e) {
                if (i == numberOfAttempts) {
                    throw new Exception("Couldn't find element");
                }
                this.driver.navigate().refresh();
                this.waitForJSandJQueryToLoad();
                continue;
            }
        }
    }

    public void clickElementAndFluentWaitForPresence(String webElement, int numberOfAttempts, int timePeriod, String elementToBeVisible) throws Exception {
        fWait = new WebDriverWait(this.driver, Duration.ofSeconds(timePeriod));
        this.driver.navigate().refresh();
        for (int i = 1; i <= numberOfAttempts; ++i) {
            try {
                System.out.println("Attempt number " + i + " With time period " + timePeriod + " seconds for the element to be present");
                this.actions.clickAction(By.xpath((String)webElement));
                fWait.until((Function)ExpectedConditions.presenceOfElementLocated((By)By.xpath((String)elementToBeVisible)));
                break;
            }
            catch (Exception e) {
                if (i == numberOfAttempts) {
                    throw new Exception("Couldn't find element");
                }
                this.driver.navigate().refresh();
                this.waitForJSandJQueryToLoad();
                continue;
            }
        }
    }

    public void fluentWaitForInVisibility(int numberOfAttempts, int timePeriod, String elementToBeVisible) throws Exception {
        fWait = new WebDriverWait(this.driver, Duration.ofSeconds(timePeriod));
        for (int i = 1; i <= numberOfAttempts; ++i) {
            try {
                System.out.println("Attempt number " + i + " With time period " + timePeriod + " seconds for the element to be visible");
                fWait.until((Function)ExpectedConditions.invisibilityOfElementLocated((By)By.xpath((String)elementToBeVisible)));
                break;
            }
            catch (Exception e) {
                if (i == numberOfAttempts) {
                    throw new Exception("Couldn't find element");
                }
                this.driver.navigate().refresh();
                this.waitForJSandJQueryToLoad();
                continue;
            }
        }
    }
}

