/*
 * Decompiled with CFR 0.152.
 */
package oit.validations;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.testng.Assert;

public class Validations {
    public WebDriver driver;
    public String currentValue;

    public Validations(WebDriver driver) {
        this.driver = driver;
    }

    public void assertEqualsValue(String actualValue, String currentURL) {
        if (this.driver.getCurrentUrl().equals(currentURL)) {
            this.currentValue = this.driver.getPageSource();
            Assert.assertTrue((boolean)this.currentValue.contains(actualValue));
        }
    }

    public void validateNotFound(String actualValue, String currentURL) {
        if (this.driver.getCurrentUrl().equals(currentURL)) {
            this.currentValue = this.driver.getPageSource();
            Assert.assertFalse((boolean)this.currentValue.contains(actualValue));
        }
    }

    public void assertNotEqualsValue(String expectedValue, String currentValue) {
        Assert.assertNotSame((Object)expectedValue, (Object)currentValue);
    }

    public void validateOnTittle(String actualValue) {
        this.currentValue = this.driver.getTitle();
        Assert.assertEquals((String)actualValue, (String)this.currentValue);
    }

    public void validateTitleContains(String expectedValue) {
        this.currentValue = this.driver.getTitle();
        Assert.assertTrue((boolean)this.currentValue.contains(expectedValue));
    }

    public void assertTwoValuesTrue(String expectedvalue, String currentvalue) {
        Assert.assertEquals((String)expectedvalue, (String)currentvalue);
        System.out.println("Two Values are equal");
    }

    public void assertEqualsByInt(int expectedvalue, int currentvalue) {
        Assert.assertEquals((int)expectedvalue, (int)currentvalue);
    }

    public void validateTextContains(String currentValue, String expectedValue) {
        Assert.assertTrue((boolean)currentValue.contains(expectedValue));
    }

    public void validateTextNOTContains(String currentValue, String expectedValue) {
        Assert.assertFalse((boolean)currentValue.contains(expectedValue));
    }

    public void assertInnerHTMLContainTrue(String xpath, String actualValue) {
        WebElement element = this.driver.findElement(By.xpath((String)xpath));
        this.currentValue = element.getAttribute("innerHTML");
        Assert.assertTrue((boolean)this.currentValue.contains(actualValue));
    }

    public void assertInnerHTMLContainFalse(String xpath, String actualValue) {
        WebElement element = this.driver.findElement(By.xpath((String)xpath));
        this.currentValue = element.getAttribute("innerHTML");
        Assert.assertFalse((boolean)this.currentValue.contains(actualValue));
    }

    public boolean isElementPresent(String webElement) {
        try {
            this.driver.findElement(By.xpath((String)webElement));
            return true;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public void validateElementFound(String webElement) {
        boolean element;
        try {
            this.driver.findElement(By.xpath((String)webElement));
            element = true;
        }
        catch (NoSuchElementException e) {
            element = false;
        }
        Assert.assertTrue((boolean)element, (String)"Element is not found");
    }

    public void validateElementNotFound(String webElement) {
        boolean element;
        try {
            this.driver.findElement(By.xpath((String)webElement));
            element = true;
        }
        catch (NoSuchElementException e) {
            element = false;
        }
        Assert.assertFalse((boolean)element, (String)"Element is found and displayed");
    }
}

