/*
 * Decompiled with CFR 0.152.
 */
package io.github.oneincase.handler;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import io.github.oneincase.config.BaseConfig;
import io.github.oneincase.core.KeloopRes;
import io.github.oneincase.core.ReqBaseParams;
import io.github.oneincase.enums.ReqTypeEnum;
import io.github.oneincase.exception.RespException;
import io.github.oneincase.utils.SignUtils;
import java.util.Map;

public class HttpHandler {
    private static final String CONTENT_TYPE = "application/x-www-form-urlencoded;charset=UTF-8";
    private static final int TIMEOUT = 3000;

    public static KeloopRes http(String url, ReqTypeEnum reqTypeEnum, ReqBaseParams reqBaseParams, BaseConfig baseConfig) {
        System.out.println(StrUtil.format((CharSequence)"\u3010==\u5feb\u8dd1\u8005== \u8bf7\u6c42\u7c7b\u578b: {} ,\u8bf7\u6c42\u5730\u5740: {}\u3011", (Object[])new Object[]{reqTypeEnum.name(), url}));
        ReqBaseParams params = SignUtils.setSign(reqBaseParams, baseConfig);
        JSONObject jsonObject = JSONUtil.parseObj((Object)params);
        jsonObject.putIfAbsent((Object)"body", (Object)"[]");
        String body = MapUtil.join((Map)jsonObject, (String)"&", (String)"=", (String[])new String[]{""});
        System.out.println(StrUtil.format((CharSequence)"\u3010==\u5feb\u8dd1\u8005== \u8bf7\u6c42\u53c2\u6570: {}\u3011", (Object[])new Object[]{body}));
        KeloopRes keloopRes = null;
        Integer timeout = baseConfig.getTimeout() != null ? baseConfig.getTimeout() : 3000;
        if ("GET".equals(reqTypeEnum.name())) {
            keloopRes = HttpHandler.get(url, body, timeout);
        } else if ("POST".equals(reqTypeEnum.name())) {
            keloopRes = HttpHandler.post(url, body, timeout);
        }
        if (keloopRes == null) {
            throw new RespException("\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        if (keloopRes.getCode() == 204) {
            throw new RespException(StrUtil.format((CharSequence)"\u3010==\u5feb\u8dd1\u8005== \u8bf7\u6c42\u5931\u8d25: {}\u3011", (Object[])new Object[]{keloopRes.getMessage()}));
        }
        System.out.println(StrUtil.format((CharSequence)"\u3010==\u5feb\u8dd1\u8005== \u8bf7\u6c42\u6210\u529f: {}\u3011", (Object[])new Object[]{keloopRes.getData()}));
        keloopRes.setSign(params.getSign());
        return keloopRes;
    }

    private static KeloopRes get(String url, String body, Integer timeout) {
        String res = ((HttpRequest)HttpRequest.get((String)url).header(Header.CONTENT_TYPE, CONTENT_TYPE)).body(body).timeout(timeout.intValue()).execute().body();
        return (KeloopRes)JSONUtil.toBean((String)res, KeloopRes.class);
    }

    private static KeloopRes post(String url, String body, Integer timeout) {
        String res = ((HttpRequest)HttpRequest.post((String)url).header(Header.CONTENT_TYPE, CONTENT_TYPE)).body(body).timeout(timeout.intValue()).execute().body();
        return (KeloopRes)JSONUtil.toBean((String)res, KeloopRes.class);
    }
}

