/*
 * Decompiled with CFR 0.152.
 */
package io.github.oneincase.utils;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestAlgorithm;
import cn.hutool.crypto.digest.Digester;
import cn.hutool.json.JSONUtil;
import io.github.oneincase.config.BaseConfig;
import io.github.oneincase.core.ReqBaseParams;
import io.github.oneincase.exception.ConfigException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SignUtils {
    private static final List<String> EXCEPTION = ListUtil.of((Object[])new String[]{"sign", "sign_type", "key"});

    public static ReqBaseParams setSign(ReqBaseParams reqBaseParams, BaseConfig baseConfig) {
        if (StrUtil.isBlank((CharSequence)baseConfig.getDevSecret())) {
            throw new ConfigException("\u7b7e\u540d\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Map filterMap = MapUtil.filter((Map)JSONUtil.parseObj((Object)reqBaseParams), r -> StrUtil.isNotBlank((CharSequence)((CharSequence)r.getKey())) && !EXCEPTION.contains(r.getKey()) && !StrUtil.isBlankIfStr(r.getValue()));
        if (!filterMap.containsKey("body") || filterMap.get("body") == null) {
            filterMap.put("body", "[]");
        }
        TreeMap map = MapUtil.sort((Map)filterMap);
        String signStr = MapUtil.join((Map)map, (String)"&", (String)"=", (boolean)false, (String[])new String[]{baseConfig.getDevSecret()});
        System.out.println(StrUtil.format((CharSequence)"\u3010==\u5feb\u8dd1\u8005== \u5f85\u7b7e\u540d\u5b57\u7b26\u4e32: {}\u3011", (Object[])new Object[]{signStr}));
        Digester md5 = new Digester(DigestAlgorithm.MD5);
        String digestHex = md5.digestHex(signStr, CharsetUtil.CHARSET_UTF_8);
        reqBaseParams.setSign(digestHex);
        System.out.println(StrUtil.format((CharSequence)"\u3010==\u5feb\u8dd1\u8005== \u7b7e\u540d\u6210\u529f: {}\u3011", (Object[])new Object[]{digestHex}));
        return reqBaseParams;
    }

    public static String getSign(ReqBaseParams reqBaseParams, BaseConfig baseConfig) {
        return SignUtils.setSign(reqBaseParams, baseConfig).getSign();
    }
}

