/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.AsyncContextSupplier;
import feign.Contract;
import feign.DefaultMethodHandler;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.MethodMetadata;
import feign.Target;
import feign.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ReflectiveFeign<C>
extends Feign {
    private final ParseHandlersByName<C> targetToHandlersByName;
    private final InvocationHandlerFactory factory;
    private final AsyncContextSupplier<C> defaultContextSupplier;

    ReflectiveFeign(Contract contract, InvocationHandlerFactory.MethodHandler.Factory<C> methodHandlerFactory, InvocationHandlerFactory invocationHandlerFactory, AsyncContextSupplier<C> defaultContextSupplier) {
        this.targetToHandlersByName = new ParseHandlersByName<C>(contract, methodHandlerFactory);
        this.factory = invocationHandlerFactory;
        this.defaultContextSupplier = defaultContextSupplier;
    }

    @Override
    public <T> T newInstance(Target<T> target) {
        return this.newInstance(target, this.defaultContextSupplier.newContext());
    }

    public <T> T newInstance(Target<T> target, C requestContext) {
        TargetSpecificationVerifier.verify(target);
        Map<Method, InvocationHandlerFactory.MethodHandler> methodToHandler = this.targetToHandlersByName.apply(target, requestContext);
        InvocationHandler handler = this.factory.create(target, methodToHandler);
        Object proxy = Proxy.newProxyInstance(target.type().getClassLoader(), new Class[]{target.type()}, handler);
        for (InvocationHandlerFactory.MethodHandler methodHandler : methodToHandler.values()) {
            if (!(methodHandler instanceof DefaultMethodHandler)) continue;
            ((DefaultMethodHandler)methodHandler).bindTo(proxy);
        }
        return (T)proxy;
    }

    private static class TargetSpecificationVerifier {
        private TargetSpecificationVerifier() {
        }

        public static <T> void verify(Target<T> target) {
            Class<T> type2 = target.type();
            if (!type2.isInterface()) {
                throw new IllegalArgumentException("Type must be an interface: " + type2);
            }
            for (Method m : type2.getMethods()) {
                Class<?> retType = m.getReturnType();
                if (!CompletableFuture.class.isAssignableFrom(retType)) continue;
                if (retType != CompletableFuture.class) {
                    throw new IllegalArgumentException("Method return type is not CompleteableFuture: " + TargetSpecificationVerifier.getFullMethodName(type2, retType, m));
                }
                Type genRetType = m.getGenericReturnType();
                if (!(genRetType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Method return type is not parameterized: " + TargetSpecificationVerifier.getFullMethodName(type2, genRetType, m));
                }
                if (!(((ParameterizedType)genRetType).getActualTypeArguments()[0] instanceof WildcardType)) continue;
                throw new IllegalArgumentException("Wildcards are not supported for return-type parameters: " + TargetSpecificationVerifier.getFullMethodName(type2, genRetType, m));
            }
        }

        private static String getFullMethodName(Class<?> type2, Type retType, Method m) {
            return retType.getTypeName() + " " + type2.toGenericString() + "." + m.getName();
        }
    }

    private static final class ParseHandlersByName<C> {
        private final Contract contract;
        private final InvocationHandlerFactory.MethodHandler.Factory<C> factory;

        ParseHandlersByName(Contract contract, InvocationHandlerFactory.MethodHandler.Factory<C> factory) {
            this.contract = contract;
            this.factory = factory;
        }

        public Map<Method, InvocationHandlerFactory.MethodHandler> apply(Target target, C requestContext) {
            LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler> result2 = new LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler>();
            List<MethodMetadata> metadataList = this.contract.parseAndValidateMetadata(target.type());
            for (MethodMetadata md : metadataList) {
                Method method = md.method();
                if (method.getDeclaringClass() == Object.class) continue;
                InvocationHandlerFactory.MethodHandler handler = this.createMethodHandler(target, md, requestContext);
                result2.put(method, handler);
            }
            for (Method method : target.type().getMethods()) {
                if (!Util.isDefault(method)) continue;
                DefaultMethodHandler handler = new DefaultMethodHandler(method);
                result2.put(method, handler);
            }
            return result2;
        }

        private InvocationHandlerFactory.MethodHandler createMethodHandler(Target<?> target, MethodMetadata md, C requestContext) {
            if (md.isIgnored()) {
                return args2 -> {
                    throw new IllegalStateException(md.configKey() + " is not a method handled by feign");
                };
            }
            return this.factory.create(target, md, requestContext);
        }
    }

    static class FeignInvocationHandler
    implements InvocationHandler {
        private final Target target;
        private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

        FeignInvocationHandler(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            this.target = Util.checkNotNull(target, "target", new Object[0]);
            this.dispatch = Util.checkNotNull(dispatch, "dispatch for %s", target);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            if ("equals".equals(method.getName())) {
                try {
                    InvocationHandler otherHandler = args2.length > 0 && args2[0] != null ? Proxy.getInvocationHandler(args2[0]) : null;
                    return this.equals(otherHandler);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if ("hashCode".equals(method.getName())) {
                return this.hashCode();
            }
            if ("toString".equals(method.getName())) {
                return this.toString();
            }
            if (!this.dispatch.containsKey(method)) {
                throw new UnsupportedOperationException(String.format("Method \"%s\" should not be called", method.getName()));
            }
            return this.dispatch.get(method).invoke(args2);
        }

        public boolean equals(Object obj) {
            if (obj instanceof FeignInvocationHandler) {
                FeignInvocationHandler other = (FeignInvocationHandler)obj;
                return this.target.equals(other.target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            return this.target.toString();
        }
    }
}

