package io.github.opensabe.mapstruct.core;

import io.github.opensabe.mapstruct.core.MapperRepository;
import io.github.opensabe.mapstruct.core.CustomerMapper;
import io.github.opensabe.mapstruct.core.CommonCopyMapper;
import io.github.opensabe.mapstruct.core.SelfCopyMapper;
import io.github.opensabe.mapstruct.core.FromMapMapper;
import org.mapstruct.factory.Mappers;
<#list mappers as i>
import ${i.className};
</#list>
public class CustomerMapperImpl implements CustomerMapper {

    public CustomerMapperImpl (MapperRepository repository) {
        Object mapper;
        <#list mappers as m>
        mapper = Mappers.getMapper(${m.name}.class);
        if (mapper instanceof FromMapMapper map){
            repository.registerMapper (${m.target}.class, map);
        }else if (mapper instanceof CommonCopyMapper) {
            if(mapper instanceof SelfCopyMapper self){
                repository.registerMapper (${m.target}.class, self);
            }else {
                repository.registerMapper (${m.source}.class, ${m.target}.class, (CommonCopyMapper)mapper);
            }
        }
        </#list>
    }
}