/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.mapstruct.processor;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import io.github.opensabe.mapstruct.core.Binding;
import io.github.opensabe.mapstruct.processor.AbstractMapper;
import io.github.opensabe.mapstruct.processor.MapperRep;
import io.github.opensabe.mapstruct.processor.MetaDataFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedAnnotationTypes(value={"io.github.opensabe.mapstruct.core.Binding"})
public class MapperGeneratorProcessor
extends AbstractProcessor {
    private Elements elementUtils;
    private Filer filer;
    private Types typeUtils;
    private TypeMirror bindingMirror;
    static MapperRep mappers = new MapperRep();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.typeUtils = processingEnv.getTypeUtils();
        this.bindingMirror = this.elementUtils.getTypeElement(Binding.class.getName()).asType();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            HashSet<? extends AbstractMapper> maps = new HashSet<AbstractMapper>();
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> beans = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : beans) {
                    List bindings = element.getAnnotationMirrors().stream().filter(m -> this.typeUtils.isSameType(m.getAnnotationType(), this.bindingMirror)).collect(Collectors.toList());
                    maps.addAll(MetaDataFactory.create(this.elementUtils, element, bindings));
                }
            }
            for (AbstractMapper abstractMapper : maps) {
                if (mappers.contains(abstractMapper)) continue;
                String className = abstractMapper.getPackageName() + "." + abstractMapper.getMapperName();
                try {
                    Writer writer = this.filer.createSourceFile(className, new Element[0]).openWriter();
                    try {
                        Configuration configuration = new Configuration(new Version("2.3.32"));
                        configuration.setClassForTemplateLoading(MapperGeneratorProcessor.class, "/");
                        configuration.setDefaultEncoding("UTF-8");
                        Template template = configuration.getTemplate(abstractMapper.template());
                        template.process((Object)abstractMapper, writer);
                        writer.flush();
                        mappers.add(abstractMapper);
                    }
                    finally {
                        if (writer == null) continue;
                        writer.close();
                    }
                }
                catch (TemplateException | IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        return false;
    }
}

