/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.mapstruct.processor;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.Version;
import io.github.opensabe.mapstruct.core.CommonCopyMapper;
import io.github.opensabe.mapstruct.core.CustomerMapper;
import io.github.opensabe.mapstruct.core.FromMapMapper;
import io.github.opensabe.mapstruct.processor.MapperRegister;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.Mapper;

@SupportedAnnotationTypes(value={"io.github.opensabe.mapstruct.core.RegisterMapper"})
public class MapperRegisterProcessor
extends AbstractProcessor {
    private Types typeUtils;
    private Elements elementUtils;
    private Element commonMapper;
    private Element mapMapper;
    private Filer filer;
    private Set<MapperRegister> mappers = new HashSet<MapperRegister>();
    private TypeMirror mapperMirror;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.commonMapper = this.elementUtils.getTypeElement(CommonCopyMapper.class.getName());
        this.mapMapper = this.elementUtils.getTypeElement(FromMapMapper.class.getName());
        this.filer = processingEnv.getFiler();
        this.mapperMirror = this.elementUtils.getTypeElement(Mapper.class.getName()).asType();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> mappers = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : mappers) {
                    if (!this.hasMapperAnnotation(element) || !(element instanceof TypeElement)) continue;
                    TypeElement typeElement2 = (TypeElement)element;
                    typeElement2.getInterfaces().stream().filter(this::resolveType).forEach(typeMirror -> {
                        if (typeMirror instanceof DeclaredType) {
                            DeclaredType declaredType = (DeclaredType)typeMirror;
                            List<? extends TypeMirror> args = declaredType.getTypeArguments();
                            if (args.size() == 2) {
                                this.mappers.add(new MapperRegister(mapper.toString(), args.get(0).toString(), args.get(1).toString()));
                            } else {
                                this.mappers.add(new MapperRegister(mapper.toString(), null, args.get(0).toString()));
                            }
                        }
                    });
                }
            }
        } else {
            try (Writer writer = this.filer.createSourceFile(CustomerMapper.class.getName() + "Impl", new Element[0]).openWriter();){
                Configuration configuration = new Configuration(new Version("2.3.32"));
                configuration.setClassForTemplateLoading(MapperRegisterProcessor.class, "/");
                configuration.setDefaultEncoding("UTF-8");
                Template template = configuration.getTemplate(CustomerMapper.class.getSimpleName() + ".ftl");
                template.process(Map.of("mappers", this.mappers), writer);
                writer.flush();
            }
            catch (TemplateException | IOException ex) {
                throw new IllegalStateException(ex);
            }
            finally {
                this.mappers.clear();
            }
        }
        return false;
    }

    private boolean resolveType(TypeMirror type) {
        Element element = this.typeUtils.asElement(type);
        PackageElement pack = this.elementUtils.getPackageOf(element);
        return pack.equals(this.elementUtils.getPackageOf(this.commonMapper)) && element.getSimpleName().equals(this.commonMapper.getSimpleName()) || pack.equals(this.elementUtils.getPackageOf(this.mapMapper)) && element.getSimpleName().equals(this.mapMapper.getSimpleName());
    }

    private boolean hasMapperAnnotation(Element mapper) {
        return mapper.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).anyMatch(a -> this.typeUtils.isSameType((TypeMirror)a, this.mapperMirror));
    }
}

